/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache.annotation;

import java.io.Serializable;
import javax.cache.Cache;
import javax.cache.annotation.CacheKeyGenerator;
import javax.cache.annotation.CacheKeyInvocationContext;
import javax.cache.annotation.CachePut;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextFactory;
import org.infinispan.jcache.annotation.CacheKeyInvocationContextImpl;
import org.infinispan.jcache.logging.Log;
import org.infinispan.util.logging.LogFactory;

@Interceptor
@CachePut
public class CachePutInterceptor
implements Serializable {
    private static final long serialVersionUID = 270924196162168618L;
    private static final Log log = (Log)LogFactory.getLog(CachePutInterceptor.class, Log.class);
    private final CacheResolver cacheResolver;
    private final CacheKeyInvocationContextFactory contextFactory;

    @Inject
    public CachePutInterceptor(CacheResolver cacheResolver, CacheKeyInvocationContextFactory contextFactory) {
        this.cacheResolver = cacheResolver;
        this.contextFactory = contextFactory;
    }

    @AroundInvoke
    public Object cachePut(InvocationContext invocationContext) throws Exception {
        if (log.isTraceEnabled()) {
            log.tracef("Interception of method named '%s'", invocationContext.getMethod().getName());
        }
        CacheKeyInvocationContext cacheKeyInvocationContext = this.contextFactory.getCacheKeyInvocationContext(invocationContext);
        CacheKeyGenerator cacheKeyGenerator = ((CacheKeyInvocationContextImpl)cacheKeyInvocationContext.unwrap(CacheKeyInvocationContextImpl.class)).getCacheKeyGenerator();
        CachePut cachePut = (CachePut)cacheKeyInvocationContext.getCacheAnnotation();
        GeneratedCacheKey cacheKey = cacheKeyGenerator.generateCacheKey(cacheKeyInvocationContext);
        Cache cache = this.cacheResolver.resolveCache(cacheKeyInvocationContext);
        Object valueToCache = cacheKeyInvocationContext.getValueParameter().getValue();
        if (!cachePut.afterInvocation() && valueToCache != null) {
            cache.put((Object)cacheKey, valueToCache);
            if (log.isTraceEnabled()) {
                log.tracef("Value '%s' cached in cache '%s' with key '%s' before method invocation", valueToCache, cache.getName(), cacheKey);
            }
        }
        Object result = invocationContext.proceed();
        if (cachePut.afterInvocation() && valueToCache != null) {
            cache.put((Object)cacheKey, valueToCache);
            if (log.isTraceEnabled()) {
                log.tracef("Value '%s' cached in cache '%s' with key '%s' after method invocation", valueToCache, cache.getName(), cacheKey);
            }
        }
        return result;
    }
}

