/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jcache;

import javax.cache.CacheException;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriterException;
import javax.cache.processor.EntryProcessorException;
import org.infinispan.commons.CacheListenerException;
import org.infinispan.persistence.spi.PersistenceException;

public class Exceptions {
    private Exceptions() {
    }

    static RuntimeException launderCacheLoaderException(Exception e) {
        if (!(e instanceof CacheLoaderException)) {
            return new CacheLoaderException("Exception in CacheLoader", (Throwable)e);
        }
        return new PersistenceException((Throwable)e);
    }

    static RuntimeException launderCacheWriterException(Exception e) {
        if (!(e instanceof CacheWriterException)) {
            return new CacheWriterException("Exception in CacheWriter", (Throwable)e);
        }
        return new CacheException("Error in CacheWriter", (Throwable)e);
    }

    static RuntimeException launderEntryProcessorException(Exception e) {
        if (!(e instanceof EntryProcessorException)) {
            return new EntryProcessorException((Throwable)e);
        }
        return new CacheException((Throwable)e);
    }

    static RuntimeException launderCacheListenerException(CacheListenerException e) {
        Throwable cause = e.getCause();
        if (cause instanceof CacheEntryListenerException) {
            return (CacheEntryListenerException)cause;
        }
        if (cause instanceof Exception) {
            return new CacheEntryListenerException(cause);
        }
        if (cause instanceof Error) {
            throw (Error)cause;
        }
        return e;
    }
}

