/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr.infinispan;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.jopr.infinispan.InfinispanComponent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheDiscovery
implements ResourceDiscoveryComponent<InfinispanComponent> {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String CACHE_QUERY = "*:cache-name=%name%,jmx-resource=CacheMgmtInterceptor";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<InfinispanComponent> discoveryContext) throws Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        EmsConnection conn = ((InfinispanComponent)discoveryContext.getParentResourceComponent()).getConnection();
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(CACHE_QUERY);
        List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
        for (EmsBean bean : beans) {
            String name = bean.getBeanName().getCanonicalName();
            name = name.substring(name.indexOf("jmx-resource=") + 13);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), bean.getBeanName().getCanonicalName(), name, null, "One cache within Infinispan", discoveryContext.getDefaultPluginConfiguration(), null);
            discoveredResources.add(detail);
            this.log.info((Object)("Discovered new ...  " + bean.getBeanName().getCanonicalName()));
        }
        return discoveredResources;
    }
}

