/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr.infinispan;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.infinispan.jopr.infinispan.InfinispanComponent;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;

public class CacheComponent
implements ResourceComponent<InfinispanComponent>,
MeasurementFacet,
OperationFacet {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final Map<String, String> abbrevToMBean = new HashMap<String, String>();
    private ResourceContext<InfinispanComponent> context;
    private String myNamePattern;

    public AvailabilityType getAvailability() {
        return ((InfinispanComponent)this.context.getParentResourceComponent()).getAvailability();
    }

    public void start(ResourceContext<InfinispanComponent> context) throws Exception {
        this.context = context;
        this.myNamePattern = context.getResourceKey();
        this.myNamePattern = this.myNamePattern.substring(0, this.myNamePattern.indexOf("jmx-resource=") + 13);
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        EmsConnection conn = this.getConnection();
        for (MeasurementScheduleRequest req : metrics) {
            String metric = req.getName();
            try {
                MeasurementDataNumeric res;
                Number tmp;
                String abbrev = metric.substring(0, metric.indexOf("."));
                String mbean = abbrevToMBean.get(abbrev);
                mbean = this.myNamePattern + mbean;
                EmsBean bean = conn.getBean(mbean);
                bean.refreshAttributes();
                String attName = metric.substring(metric.indexOf(".") + 1);
                EmsAttribute att = bean.getAttribute(attName);
                Object o = att.getValue();
                Class type = att.getTypeClass();
                if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                    tmp = (Long)o;
                    res = new MeasurementDataNumeric(req, Double.valueOf(((Long)tmp).longValue()));
                    report.addData(res);
                    continue;
                }
                if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                    tmp = (Double)o;
                    res = new MeasurementDataNumeric(req, (Double)tmp);
                    report.addData(res);
                    continue;
                }
                if (!type.equals(Integer.class) && !type.equals(Integer.TYPE)) continue;
                tmp = (Integer)o;
                res = new MeasurementDataNumeric(req, Double.valueOf(((Integer)tmp).intValue()));
                report.addData(res);
            }
            catch (Exception e) {
                this.log.warn((Object)("getValues failed for " + metric + " : "), (Throwable)e);
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        String opName;
        EmsConnection conn = this.getConnection();
        String abbrev = name.substring(0, name.indexOf("."));
        String mbean = abbrevToMBean.get(abbrev);
        mbean = this.myNamePattern + mbean;
        EmsBean bean = conn.getBean(mbean);
        EmsOperation ops = bean.getOperation(opName = name.substring(name.indexOf(".") + 1));
        if (ops == null) {
            throw new Exception("Operation " + name + " can't be found");
        }
        ops.invoke(new Object[0]);
        return new OperationResult();
    }

    private EmsConnection getConnection() {
        return ((InfinispanComponent)this.context.getParentResourceComponent()).getConnection();
    }

    static {
        abbrevToMBean.put("Statistics", "Statistics");
        abbrevToMBean.put("LockManager", "LockManager");
        abbrevToMBean.put("Transactions", "Transactions");
    }
}

