/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.infinispan.jopr.CacheManagerComponent;
import org.infinispan.jopr.ConnectionHelper;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jmx.ObjectNameQueryUtility;

public class CacheManagerDiscovery
implements ResourceDiscoveryComponent<CacheManagerComponent> {
    private static final Log log = LogFactory.getLog(CacheManagerDiscovery.class);
    public static String REMOTE = "service:jmx:rmi://127.0.0.1/jndi/rmi://127.0.0.1:6996/jmxrmi";
    private static final String MANAGER_OBJECT = "*:cache-name=[global],jmx-resource=CacheManager";
    private static final String CONNECTOR = "org.mc4j.ems.connection.support.metadata.J2SE5ConnectionTypeDescriptor";

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext<CacheManagerComponent> discoveryContext) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Discover resources with context: {0}", new Object[]{discoveryContext});
        }
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        Configuration c = new Configuration();
        c.put((Property)new PropertySimple("connectorAddress", (Object)REMOTE));
        c.put((Property)new PropertySimple("type", (Object)CONNECTOR));
        c.put((Property)new PropertySimple("objectName", (Object)MANAGER_OBJECT));
        if (trace) {
            log.trace((Object)"To be used configuration is {0}", new Object[]{c.toString(true)});
        }
        ConnectionHelper helper = new ConnectionHelper();
        EmsConnection conn = helper.getEmsConnection(c);
        if (trace) {
            log.trace((Object)"Connection to ems server stablished: {0}", new Object[]{conn});
        }
        ObjectNameQueryUtility queryUtility = new ObjectNameQueryUtility(MANAGER_OBJECT);
        List beans = conn.queryBeans(queryUtility.getTranslatedQuery());
        if (trace) {
            log.trace((Object)"Querying [{0}] returned beans: {1}", new Object[]{queryUtility.getTranslatedQuery(), beans});
        }
        for (EmsBean bean : beans) {
            String managerName = bean.getBeanName().getCanonicalName();
            c.put((Property)new PropertySimple("objectName", (Object)managerName));
            String resourceName = bean.getAttribute("Name").getValue().toString();
            String version = bean.getAttribute("Version").getValue().toString();
            if (trace) {
                log.trace((Object)"Add resource with name '{0}', version '{1}' and type {2}", new Object[]{resourceName, version, discoveryContext.getResourceType()});
            }
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), managerName, resourceName, version, "A cache manager within Infinispan", c, null);
            discoveredResources.add(detail);
            log.info((Object)"Discovered Infinispan instance: {0}", new Object[]{managerName});
        }
        return discoveredResources;
    }
}

