/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.jopr;

import java.util.Set;
import org.infinispan.jopr.CacheManagerComponent;
import org.infinispan.lifecycle.ComponentStatus;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;
import org.mc4j.ems.connection.EmsConnection;
import org.mc4j.ems.connection.bean.EmsBean;
import org.mc4j.ems.connection.bean.attribute.EmsAttribute;
import org.mc4j.ems.connection.bean.operation.EmsOperation;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.DataType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementDataTrait;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceComponent;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.core.pluginapi.measurement.MeasurementFacet;
import org.rhq.core.pluginapi.operation.OperationFacet;
import org.rhq.core.pluginapi.operation.OperationResult;

public class CacheComponent
implements ResourceComponent<CacheManagerComponent>,
MeasurementFacet,
OperationFacet {
    private static final Log log = LogFactory.getLog(CacheComponent.class);
    private ResourceContext<CacheManagerComponent> context;
    private String myNamePattern;

    public AvailabilityType getAvailability() {
        boolean trace = log.isTraceEnabled();
        EmsConnection conn = this.getConnection();
        try {
            conn.refresh();
            EmsBean bean = conn.getBean(this.context.getResourceKey());
            EmsAttribute attribute = bean.getAttribute("CacheStatus");
            if (attribute.getValue().equals(ComponentStatus.RUNNING.toString())) {
                bean.refreshAttributes();
                if (trace) {
                    log.trace((Object)"Cache status is running and attributes could be refreshed, so it's up.");
                }
                return AvailabilityType.UP;
            }
            if (trace) {
                log.trace((Object)"Cache status is anything other than running, so it's down.");
            }
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            if (trace) {
                log.trace((Object)"There was an exception checking availability, so cache status is down.");
            }
            return AvailabilityType.DOWN;
        }
    }

    public void start(ResourceContext<CacheManagerComponent> context) throws Exception {
        this.context = context;
        this.myNamePattern = context.getResourceKey();
        this.myNamePattern = this.myNamePattern.substring(0, this.myNamePattern.indexOf("jmx-resource=") + 13);
    }

    public void stop() {
    }

    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> metrics) throws Exception {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Get values metrics");
        }
        EmsConnection conn = this.getConnection();
        for (MeasurementScheduleRequest req : metrics) {
            if (trace) {
                log.trace((Object)"Inspect metric {0}", new Object[]{req});
            }
            String metric = req.getName();
            try {
                String abbrev = metric.substring(0, metric.indexOf("."));
                String mbean = this.myNamePattern + abbrev;
                EmsBean bean = conn.getBean(mbean);
                if (bean != null) {
                    if (trace) {
                        log.trace((Object)"Retrieved mbean with name {0}", new Object[]{mbean});
                    }
                    bean.refreshAttributes();
                    String attName = metric.substring(metric.indexOf(".") + 1);
                    EmsAttribute att = bean.getAttribute(attName);
                    if (att != null) {
                        Object o = att.getValue();
                        Class attrType = att.getTypeClass();
                        DataType type = req.getDataType();
                        if (type == DataType.MEASUREMENT) {
                            if (o != null) {
                                MeasurementDataNumeric res = this.constructMeasurementDataNumeric(attrType, o, req);
                                if (res == null) continue;
                                report.addData(res);
                                continue;
                            }
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)"Metric ({0}) has null value, do not add to report", new Object[]{req.getName()});
                            continue;
                        }
                        if (type != DataType.TRAIT) continue;
                        String value = (String)o;
                        if (trace) {
                            log.trace((Object)"Metric ({0}) is trait with value {1}", new Object[]{req.getName(), value});
                        }
                        MeasurementDataTrait res = new MeasurementDataTrait(req, value);
                        report.addData(res);
                        continue;
                    }
                    log.warn((Object)"Attribute {0} not found", new Object[]{attName});
                    continue;
                }
                if (!trace) continue;
                log.trace((Object)"No mbean found with name {0}", new Object[]{mbean});
            }
            catch (Exception e) {
                log.warn((Object)("getValues failed for " + metric + " : "), (Throwable)e);
            }
        }
    }

    public OperationResult invokeOperation(String name, Configuration parameters) throws Exception {
        String opName;
        EmsConnection conn = this.getConnection();
        String abbrev = name.substring(0, name.indexOf("."));
        String mbean = this.myNamePattern + abbrev;
        EmsBean bean = conn.getBean(mbean);
        EmsOperation ops = bean.getOperation(opName = name.substring(name.indexOf(".") + 1));
        if (ops == null) {
            throw new Exception("Operation " + name + " can't be found");
        }
        ops.invoke(new Object[0]);
        return new OperationResult();
    }

    private EmsConnection getConnection() {
        return ((CacheManagerComponent)this.context.getParentResourceComponent()).getConnection();
    }

    private MeasurementDataNumeric constructMeasurementDataNumeric(Class attrType, Object o, MeasurementScheduleRequest req) {
        boolean trace = log.isTraceEnabled();
        if (trace) {
            log.trace((Object)"Metric ({0}) is measurement with value {1}", new Object[]{req.getName(), o});
        }
        if (attrType.equals(Long.class) || attrType.equals(Long.TYPE)) {
            Long tmp = (Long)o;
            return new MeasurementDataNumeric(req, Double.valueOf(tmp.longValue()));
        }
        if (attrType.equals(Double.class) || attrType.equals(Double.TYPE)) {
            Double tmp = (Double)o;
            return new MeasurementDataNumeric(req, tmp);
        }
        if (attrType.equals(Integer.class) || attrType.equals(Integer.TYPE)) {
            Integer tmp = (Integer)o;
            return new MeasurementDataNumeric(req, Double.valueOf(tmp.intValue()));
        }
        if (attrType.equals(String.class)) {
            String tmp = (String)o;
            return new MeasurementDataNumeric(req, Double.valueOf(tmp));
        }
        log.warn((Object)"Unknown {0} attribute type for {1}", new Object[]{attrType, o});
        return null;
    }
}

