/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.junit4;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.time.DefaultTimeService;
import org.infinispan.commons.time.TimeService;
import org.infinispan.commons.util.Util;
import org.infinispan.server.DefaultExitHandler;
import org.infinispan.server.ExitHandler;
import org.infinispan.server.Server;
import org.infinispan.server.core.ProtocolServer;
import org.infinispan.server.hotrod.HotRodServer;
import org.infinispan.server.hotrod.configuration.HotRodServerConfiguration;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.junit4.ServerTestConfiguration;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class ServerTestRule
implements TestRule {
    List<Server> servers;
    List<CompletableFuture<Integer>> serverFutures;
    int numServers = 2;
    TimeService timeService = DefaultTimeService.INSTANCE;
    RemoteCacheManager hotRodClient;

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                String serverBaseName = description.getClassName();
                ServerTestConfiguration annotation = description.getTestClass().getAnnotation(ServerTestConfiguration.class);
                String configurationFile = "clustered.xml";
                if (annotation != null) {
                    configurationFile = annotation.configurationFile();
                    ServerTestRule.this.numServers = annotation.numServers();
                }
                ServerTestRule.this.before(serverBaseName, description.getTestClass().getClassLoader().getResource(configurationFile));
                try {
                    base.evaluate();
                }
                finally {
                    ServerTestRule.this.after();
                }
            }
        };
    }

    private void before(String serverBaseName, URL resource) {
        this.servers = new ArrayList<Server>();
        this.serverFutures = new ArrayList<CompletableFuture<Integer>>();
        for (int i = 0; i < this.numServers; ++i) {
            long start = this.timeService.time();
            String serverName = serverBaseName + "#" + i;
            File serverRoot = ServerTestRule.createServerHierarchy(serverName);
            String path = resource.getPath();
            Properties properties = new Properties();
            properties.setProperty("infinispan.socket.binding.port-offset", Integer.toString(i * 100));
            Server server = new Server(serverRoot, new File(path), properties);
            server.setExitHandler((ExitHandler)new DefaultExitHandler());
            this.serverFutures.add(server.run());
            this.servers.add(server);
        }
    }

    private void after() {
        if (this.hotRodClient != null) {
            this.hotRodClient.stop();
        }
        for (int i = 0; i < this.servers.size(); ++i) {
            long start = this.timeService.time();
            Server server = this.servers.get(i);
            server.getExitHandler().exit(0);
            try {
                this.serverFutures.get(i).get();
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            Util.recursiveFileRemove((File)server.getServerRoot());
        }
    }

    private static File createServerHierarchy(String name) {
        File tmp = new File(TestingUtil.tmpDirectory((String)name));
        for (String dir : Arrays.asList("conf", "data", "log", "lib")) {
            new File(tmp, dir).mkdirs();
        }
        return tmp;
    }

    public RemoteCacheManager hotRodClient() {
        if (this.hotRodClient == null) {
            ConfigurationBuilder builder = new ConfigurationBuilder();
            for (Server server : this.servers) {
                for (ProtocolServer ps : server.getProtocolServers().values()) {
                    if (!(ps instanceof HotRodServer)) continue;
                    HotRodServerConfiguration serverConfiguration = (HotRodServerConfiguration)((HotRodServer)ps).getConfiguration();
                    builder.addServer().host(serverConfiguration.publicHost()).port(serverConfiguration.publicPort());
                }
            }
            this.hotRodClient = new RemoteCacheManager(builder.build());
        }
        return this.hotRodClient;
    }
}

