/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import org.infinispan.lucene.AbstractIndexScopedKey;
import org.infinispan.lucene.KeyVisitor;
import org.infinispan.protostream.annotations.ProtoField;

public final class ChunkCacheKey
extends AbstractIndexScopedKey {
    @ProtoField(number=3, defaultValue="0")
    int chunkId;
    @ProtoField(number=4, name="file")
    String fileName;
    @ProtoField(number=5, defaultValue="0")
    int bufferSize;

    ChunkCacheKey() {
    }

    public ChunkCacheKey(String indexName, String fileName, int chunkId, int bufferSize, int affinitySegmentId) {
        super(indexName, affinitySegmentId);
        if (fileName == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        this.fileName = fileName;
        this.chunkId = chunkId;
        this.bufferSize = bufferSize;
    }

    public int getChunkId() {
        return this.chunkId;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Object accept(KeyVisitor visitor) throws Exception {
        return visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.chunkId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (ChunkCacheKey.class != obj.getClass()) {
            return false;
        }
        ChunkCacheKey other = (ChunkCacheKey)obj;
        if (this.chunkId != other.chunkId) {
            return false;
        }
        if (!this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "C|" + this.fileName + "|" + this.chunkId + "|" + this.bufferSize + "|" + this.indexName + "|" + this.affinitySegmentId;
    }
}

