/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import org.infinispan.lucene.AbstractIndexScopedKey;
import org.infinispan.lucene.KeyVisitor;
import org.infinispan.protostream.annotations.ProtoField;

public final class FileCacheKey
extends AbstractIndexScopedKey {
    @ProtoField(number=3, name="file")
    String fileName;

    FileCacheKey() {
    }

    public FileCacheKey(String indexName, String fileName, int affinitySegmentId) {
        super(indexName, affinitySegmentId);
        if (fileName == null) {
            throw new IllegalArgumentException("filename must not be null");
        }
        this.fileName = fileName;
    }

    public Object accept(KeyVisitor visitor) throws Exception {
        return visitor.visit(this);
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileCacheKey.class != obj.getClass()) {
            return false;
        }
        FileCacheKey other = (FileCacheKey)obj;
        if (!this.fileName.equals(other.fileName)) {
            return false;
        }
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "M|" + this.fileName + "|" + this.indexName + "|" + this.affinitySegmentId;
    }
}

