/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import org.infinispan.protostream.annotations.ProtoField;

public final class FileMetadata {
    @ProtoField(number=1, defaultValue="0")
    int bufferSize;
    @ProtoField(number=2, defaultValue="0")
    long size = 0L;

    FileMetadata() {
    }

    public FileMetadata(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getNumberOfChunks() {
        if (this.size % (long)this.bufferSize == 0L) {
            return (int)this.size / this.bufferSize;
        }
        return (int)(this.size / (long)this.bufferSize) + 1;
    }

    public boolean isMultiChunked() {
        return this.size > (long)this.bufferSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || FileMetadata.class != o.getClass()) {
            return false;
        }
        FileMetadata metadata = (FileMetadata)o;
        return this.size == metadata.size && this.bufferSize == metadata.bufferSize;
    }

    public int hashCode() {
        return (int)(this.size ^ this.size >>> 32);
    }

    public String toString() {
        return "FileMetadata{ size=" + this.size + '}';
    }
}

