/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.lucene.impl.Operation;
import org.infinispan.protostream.annotations.ProtoField;

@ThreadSafe
public final class FileListCacheValue {
    private final Set<String> filenames = new HashSet<String>();
    private final Lock writeLock;
    private final Lock readLock;

    public FileListCacheValue() {
        ReentrantReadWriteLock namesLock = new ReentrantReadWriteLock();
        this.writeLock = namesLock.writeLock();
        this.readLock = namesLock.readLock();
    }

    @ProtoField(number=1, collectionImplementation=HashSet.class, name="file_names")
    Set<String> getFileNames() {
        this.readLock.lock();
        try {
            HashSet<String> hashSet = new HashSet<String>(this.filenames);
            return hashSet;
        }
        finally {
            this.readLock.unlock();
        }
    }

    void setFileNames(Set<String> names) {
        this.writeLock.lock();
        try {
            this.filenames.addAll(names);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public FileListCacheValue(String[] listAll) {
        this();
        Collections.addAll(this.filenames, listAll);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void apply(List<Operation> operations) {
        this.writeLock.lock();
        try {
            for (Operation operation : operations) {
                operation.apply(this.filenames);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean remove(String fileName) {
        this.writeLock.lock();
        try {
            boolean bl = this.filenames.remove(fileName);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public boolean add(String fileName) {
        this.writeLock.lock();
        try {
            boolean bl = this.filenames.add(fileName);
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addAndRemove(String toAdd, String toRemove) {
        this.writeLock.lock();
        try {
            boolean doneAdd = this.filenames.add(toAdd);
            boolean doneRemove = this.filenames.remove(toRemove);
            boolean bl = doneAdd || doneRemove;
            return bl;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public String[] toArray() {
        this.readLock.lock();
        try {
            String[] stringArray = this.filenames.toArray(new String[this.filenames.size()]);
            return stringArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public boolean contains(String fileName) {
        this.readLock.lock();
        try {
            boolean bl = this.filenames.contains(fileName);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int hashCode() {
        this.readLock.lock();
        try {
            int n = this.filenames.hashCode();
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object obj) {
        HashSet<String> copyFromOther;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileListCacheValue.class != obj.getClass()) {
            return false;
        }
        FileListCacheValue other = (FileListCacheValue)obj;
        other.readLock.lock();
        try {
            copyFromOther = new HashSet<String>(other.filenames);
        }
        finally {
            other.readLock.unlock();
        }
        this.readLock.lock();
        try {
            boolean bl = this.filenames.equals(copyFromOther);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public String toString() {
        this.readLock.lock();
        try {
            String string = "FileListCacheValue [filenames=" + this.filenames + "]";
            return string;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

