/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

public final class FileMetadata {
    private final int bufferSize;
    private long size;

    @ProtoFactory
    public FileMetadata(int bufferSize, long size) {
        this.bufferSize = bufferSize;
        this.size = size;
    }

    public FileMetadata(int bufferSize) {
        this(bufferSize, 0L);
    }

    @ProtoField(number=1, defaultValue="1024")
    public int getBufferSize() {
        return this.bufferSize;
    }

    @ProtoField(number=2, defaultValue="0")
    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getNumberOfChunks() {
        int numChunks = (int)this.size / this.bufferSize;
        return this.size % (long)this.bufferSize == 0L ? numChunks : numChunks + 1;
    }

    public boolean isMultiChunked() {
        return this.size > (long)this.bufferSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || FileMetadata.class != o.getClass()) {
            return false;
        }
        FileMetadata metadata = (FileMetadata)o;
        return this.size == metadata.size && this.bufferSize == metadata.bufferSize;
    }

    public int hashCode() {
        return (int)(this.size ^ this.size >>> 32);
    }

    public String toString() {
        return "FileMetadata{size=" + this.size + '}';
    }
}

