/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import org.infinispan.lucene.AbstractIndexScopedKey;
import org.infinispan.lucene.KeyVisitor;
import org.infinispan.protostream.annotations.ProtoFactory;
import org.infinispan.protostream.annotations.ProtoField;

public final class FileReadLockKey
extends AbstractIndexScopedKey {
    private final String fileName;

    @ProtoFactory
    public FileReadLockKey(String indexName, String fileName, int affinitySegmentId) {
        super(indexName, affinitySegmentId);
        if (indexName == null) {
            throw new IllegalArgumentException("indexName shall not be null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("fileName shall not be null");
        }
        this.fileName = fileName;
    }

    @ProtoField(number=3)
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public <T> T accept(KeyVisitor<T> visitor) throws Exception {
        return visitor.visit(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 31 + this.fileName.hashCode();
        return 31 * result + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || FileReadLockKey.class != obj.getClass()) {
            return false;
        }
        FileReadLockKey other = (FileReadLockKey)obj;
        return this.fileName.equals(other.fileName) && this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "RL|" + this.fileName + "|" + this.indexName + "|" + this.affinitySegmentId;
    }
}

