/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.Serializable;
import org.infinispan.lucene.CacheKey;

final class ChunkCacheKey
implements Serializable,
CacheKey {
    private static final long serialVersionUID = 4429712073623290126L;
    private final int chunkId;
    private final String indexName;
    private final String fileName;
    private final int hashCode;

    public ChunkCacheKey(String indexName, String fileName, int chunkId) {
        this.indexName = indexName;
        this.fileName = fileName;
        this.chunkId = chunkId;
        this.hashCode = this.generatedHashCode();
    }

    public int getChunkId() {
        return this.chunkId;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generatedHashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.chunkId;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.indexName == null ? 0 : this.indexName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (ChunkCacheKey.class != obj.getClass()) {
            return false;
        }
        ChunkCacheKey other = (ChunkCacheKey)obj;
        if (this.chunkId != other.chunkId) {
            return false;
        }
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        return !(this.indexName == null ? other.indexName != null : !this.indexName.equals(other.indexName));
    }

    public String toString() {
        return "ChunkCacheKey{chunkId=" + this.chunkId + ", fileName=" + this.fileName + ", indexName=" + this.indexName + "} ";
    }
}

