/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.InfinispanIndexIO;
import org.infinispan.lucene.locking.LuceneLockFactory;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanDirectory
extends Directory {
    private static final Log log = LogFactory.getLog(InfinispanDirectory.class);
    volatile boolean isOpen = true;
    private final Cache<CacheKey, Object> cache;
    private final String indexName;
    private final int chunkSize;
    private final FileListCacheKey fileListCacheKey;

    public InfinispanDirectory(Cache<CacheKey, Object> cache, String indexName, LockFactory lf, int chunkSize) {
        this.cache = cache;
        this.indexName = indexName;
        this.setLockFactory(lf);
        this.chunkSize = chunkSize;
        this.fileListCacheKey = new FileListCacheKey(indexName);
    }

    public InfinispanDirectory(Cache<CacheKey, Object> cache, String indexName, LockFactory lf) {
        this(cache, indexName, lf, 16384);
    }

    public InfinispanDirectory(Cache<CacheKey, Object> cache, String indexName, int chunkSize) {
        this(cache, indexName, new LuceneLockFactory(cache, indexName), chunkSize);
    }

    public InfinispanDirectory(Cache<CacheKey, Object> cache, String indexName) {
        this(cache, indexName, new LuceneLockFactory(cache, indexName), 16384);
    }

    public InfinispanDirectory(Cache<CacheKey, Object> cache) {
        this(cache, "");
    }

    public String[] list() throws IOException {
        this.checkIsOpen();
        Set<String> filesList = this.getFileList();
        return filesList.toArray(new String[0]);
    }

    public boolean fileExists(String name) throws IOException {
        this.checkIsOpen();
        return this.cache.containsKey((Object)new FileCacheKey(this.indexName, name));
    }

    public long fileModified(String name) throws IOException {
        this.checkIsOpen();
        FileMetadata file = this.getFileMetadata(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    public void touchFile(String fileName) throws IOException {
        this.checkIsOpen();
        FileCacheKey key = new FileCacheKey(this.indexName, fileName);
        FileMetadata file = (FileMetadata)this.cache.get((Object)key);
        if (file == null) {
            throw new FileNotFoundException(fileName);
        }
        file.touch();
        this.cache.put((Object)key, (Object)file);
    }

    public void deleteFile(String name) throws IOException {
        Object removed;
        this.checkIsOpen();
        FileCacheKey key = new FileCacheKey(this.indexName, name);
        this.cache.remove((Object)key);
        Set<String> fileList = this.getFileList();
        fileList.remove(name);
        this.cache.put((Object)this.fileListCacheKey, fileList);
        int i = 0;
        ChunkCacheKey chunkKey = new ChunkCacheKey(this.indexName, name, i);
        do {
            removed = this.cache.remove((Object)chunkKey);
            chunkKey = new ChunkCacheKey(this.indexName, name, ++i);
        } while (removed != null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removed file: {0} from index: {1}", new Object[]{key.getFileName(), this.indexName});
        }
    }

    public void renameFile(String from, String to) throws IOException {
        ChunkCacheKey fromChunkKey;
        Object ob;
        this.checkIsOpen();
        FileCacheKey fromKey = new FileCacheKey(this.indexName, from);
        FileMetadata fileFrom = (FileMetadata)this.cache.remove((Object)fromKey);
        this.cache.put((Object)new FileCacheKey(this.indexName, to), (Object)fileFrom);
        Set<String> fileList = this.getFileList();
        fileList.remove(from);
        fileList.add(to);
        this.cache.put((Object)this.fileListCacheKey, fileList);
        int i = -1;
        while ((ob = this.cache.get((Object)(fromChunkKey = new ChunkCacheKey(this.indexName, from, ++i)))) != null) {
            ChunkCacheKey toChunkKey = new ChunkCacheKey(this.indexName, to, i);
            this.cache.put((Object)toChunkKey, ob);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"Renamed file from: {0} to: {1} in index {2}", new Object[]{from, to, this.indexName});
        }
    }

    public long fileLength(String name) throws IOException {
        this.checkIsOpen();
        FileMetadata file = this.getFileMetadata(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getSize();
    }

    public IndexOutput createOutput(String name) throws IOException {
        FileCacheKey key = new FileCacheKey(this.indexName, name);
        FileMetadata newFileMetadata = new FileMetadata();
        FileMetadata previous = (FileMetadata)this.cache.putIfAbsent((Object)key, (Object)newFileMetadata);
        if (previous == null) {
            Set<String> fileList = this.getFileList();
            fileList.add(name);
            this.cache.put((Object)this.fileListCacheKey, fileList);
            return new InfinispanIndexIO.InfinispanIndexOutput(this.cache, key, this.chunkSize, newFileMetadata);
        }
        return new InfinispanIndexIO.InfinispanIndexOutput(this.cache, key, this.chunkSize, previous);
    }

    private Set<String> getFileList() {
        Set fileList = (Set)this.cache.get((Object)this.fileListCacheKey);
        if (fileList == null) {
            fileList = new ConcurrentHashSet();
        }
        return fileList;
    }

    public IndexInput openInput(String name) throws IOException {
        FileCacheKey fileKey = new FileCacheKey(this.indexName, name);
        return new InfinispanIndexIO.InfinispanIndexInput(this.cache, fileKey, this.chunkSize);
    }

    public void close() throws IOException {
        this.isOpen = false;
    }

    private void checkIsOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }

    private FileMetadata getFileMetadata(String fileName) {
        FileCacheKey key = new FileCacheKey(this.indexName, fileName);
        return (FileMetadata)this.cache.get((Object)key);
    }

    public String toString() {
        return "InfinispanDirectory{indexName='" + this.indexName + '\'' + '}';
    }

    public Cache<CacheKey, Object> getCache() {
        return this.cache;
    }

    public String[] listAll() throws IOException {
        return this.list();
    }
}

