/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.Cache;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexIO {
    public static final int DEFAULT_BUFFER_SIZE = 16384;

    private static byte[] getChunkFromPosition(Map<CacheKey, Object> cache, FileCacheKey fileKey, int pos, int bufferSize) {
        ChunkCacheKey key = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), InfinispanIndexIO.getChunkNumberFromPosition(pos, bufferSize));
        return (byte[])cache.get(key);
    }

    private static final int getPositionInBuffer(int pos, int bufferSize) {
        return pos % bufferSize;
    }

    private static final int getChunkNumberFromPosition(int pos, int bufferSize) {
        return pos / bufferSize;
    }

    public static class InfinispanIndexOutput
    extends IndexOutput {
        private static final Log log = LogFactory.getLog(InfinispanIndexOutput.class);
        private final int bufferSize;
        private final Cache<CacheKey, Object> cache;
        private final FileMetadata file;
        private final FileCacheKey fileKey;
        private byte[] buffer;
        private int bufferPosition = 0;
        private int filePosition = 0;
        private int chunkNumber;

        public InfinispanIndexOutput(Cache<CacheKey, Object> cache, FileCacheKey fileKey, int bufferSize, FileMetadata fileMetadata) throws IOException {
            this.cache = cache;
            this.fileKey = fileKey;
            this.bufferSize = bufferSize;
            this.buffer = new byte[this.bufferSize];
            this.file = fileMetadata;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Opened new IndexOutput for file:{0} in index: {1}", new Object[]{fileKey.getFileName(), fileKey.getIndexName()});
            }
        }

        private void newChunk() throws IOException {
            this.flush();
            this.buffer = InfinispanIndexIO.getChunkFromPosition(this.cache, this.fileKey, this.filePosition, this.bufferSize);
            if (this.buffer == null) {
                this.buffer = new byte[this.bufferSize];
            }
            this.bufferPosition = 0;
        }

        public void writeByte(byte b) throws IOException {
            if (this.isNewChunkNeeded()) {
                this.newChunk();
            }
            this.buffer[this.bufferPosition++] = b;
            ++this.filePosition;
        }

        public void writeBytes(byte[] b, int offset, int length) throws IOException {
            int pieceLength;
            for (int writedBytes = 0; writedBytes < length; writedBytes += pieceLength) {
                pieceLength = Math.min(this.buffer.length - this.bufferPosition, length - writedBytes);
                System.arraycopy(b, offset + writedBytes, this.buffer, this.bufferPosition, pieceLength);
                this.bufferPosition += pieceLength;
                this.filePosition += pieceLength;
                if (!this.isNewChunkNeeded()) continue;
                this.newChunk();
            }
        }

        private boolean isNewChunkNeeded() {
            return this.bufferPosition == this.buffer.length;
        }

        public void flush() throws IOException {
            this.chunkNumber = InfinispanIndexIO.getChunkNumberFromPosition(this.filePosition - 1, this.bufferSize);
            ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.fileKey.getFileName(), this.chunkNumber);
            this.setFileLength();
            this.cache.put((Object)key, (Object)this.buffer);
            this.cache.put((Object)this.fileKey, (Object)this.file);
        }

        public void close() throws IOException {
            this.flush();
            this.bufferPosition = 0;
            this.filePosition = 0;
            this.buffer = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closed IndexOutput for file:{0} in index: {1}", new Object[]{this.fileKey.getFileName(), this.fileKey.getIndexName()});
            }
        }

        public long getFilePointer() {
            return this.filePosition;
        }

        public void seek(long pos) throws IOException {
            this.flush();
            if (pos > this.file.getSize()) {
                throw new IOException(this.fileKey.getFileName() + ": seeking past of the file");
            }
            this.buffer = InfinispanIndexIO.getChunkFromPosition(this.cache, this.fileKey, (int)pos, this.bufferSize);
            this.bufferPosition = InfinispanIndexIO.getPositionInBuffer((int)pos, this.bufferSize);
            this.filePosition = (int)pos;
        }

        public long length() throws IOException {
            return this.file.getSize();
        }

        protected void setFileLength() {
            this.file.touch();
            if (this.file.getSize() < (long)this.filePosition) {
                this.file.setSize(this.filePosition);
            }
        }
    }

    public static class InfinispanIndexInput
    extends IndexInput {
        private static final Log log = LogFactory.getLog(InfinispanIndexInput.class);
        private final int bufferSize;
        private Cache<CacheKey, Object> cache;
        private ConcurrentHashMap<CacheKey, Object> localCache = new ConcurrentHashMap();
        private FileMetadata file;
        private FileCacheKey fileKey;
        private byte[] buffer;
        private int bufferPosition = 0;
        private int filePosition = 0;
        private int lastChunkNumberLoaded = -1;

        public InfinispanIndexInput(Cache<CacheKey, Object> cache, FileCacheKey fileKey) throws IOException {
            this(cache, fileKey, 16384);
        }

        public InfinispanIndexInput(Cache<CacheKey, Object> cache, FileCacheKey fileKey, int bufferSize) throws IOException {
            Object fileChunk;
            this.cache = cache;
            this.fileKey = fileKey;
            this.bufferSize = bufferSize;
            this.buffer = new byte[this.bufferSize];
            this.file = (FileMetadata)cache.get((Object)fileKey);
            if (this.file == null) {
                throw new IOException("File [ " + fileKey.getFileName() + " ] for index [ " + fileKey.getIndexName() + " ] was not found");
            }
            int i = 0;
            ChunkCacheKey chunkKey = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), i);
            while ((fileChunk = cache.get((Object)chunkKey)) != null) {
                this.localCache.put(chunkKey, fileChunk);
                chunkKey = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), ++i);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Opened new IndexInput for file:{0} in index: {1}", new Object[]{fileKey.getFileName(), fileKey.getIndexName()});
            }
        }

        private byte[] getChunkFromPosition(Cache<CacheKey, Object> cache, FileCacheKey fileKey, int pos, int bufferSize) {
            if (this.lastChunkNumberLoaded != InfinispanIndexIO.getChunkNumberFromPosition(this.filePosition, bufferSize)) {
                byte[] object = InfinispanIndexIO.getChunkFromPosition(cache, fileKey, pos, bufferSize);
                if (object == null) {
                    object = InfinispanIndexIO.getChunkFromPosition(this.localCache, fileKey, pos, bufferSize);
                }
                this.lastChunkNumberLoaded = InfinispanIndexIO.getChunkNumberFromPosition(this.filePosition, bufferSize);
                return object;
            }
            return this.buffer;
        }

        public byte readByte() throws IOException {
            this.buffer = this.getChunkFromPosition(this.cache, this.fileKey, this.filePosition, this.bufferSize);
            if (this.buffer == null) {
                throw new IOException("Chunk id = [ " + InfinispanIndexIO.getChunkNumberFromPosition(this.filePosition, this.bufferSize) + " ] does not exist for file [ " + this.fileKey.getFileName() + " ] for index [ " + this.fileKey.getIndexName() + " ]");
            }
            this.bufferPosition = InfinispanIndexIO.getPositionInBuffer(this.filePosition++, this.bufferSize);
            return this.buffer[this.bufferPosition];
        }

        public void readBytes(byte[] b, int offset, int len) throws IOException {
            int bytesToRead = len;
            while (bytesToRead > 0) {
                this.buffer = this.getChunkFromPosition(this.cache, this.fileKey, this.filePosition, this.bufferSize);
                if (this.buffer == null) {
                    throw new IOException("Chunk id = [ " + InfinispanIndexIO.getChunkNumberFromPosition(this.filePosition, this.bufferSize) + " ] does not exist for file [ " + this.fileKey.getFileName() + " ] for index [ " + this.fileKey.getIndexName() + " ], file position: [ " + this.filePosition + " ], file size: [ " + this.file.getSize() + " ]");
                }
                this.bufferPosition = InfinispanIndexIO.getPositionInBuffer(this.filePosition, this.bufferSize);
                int bytesToCopy = Math.min(this.buffer.length - this.bufferPosition, bytesToRead);
                System.arraycopy(this.buffer, this.bufferPosition, b, offset, bytesToCopy);
                offset += bytesToCopy;
                bytesToRead -= bytesToCopy;
                this.filePosition += bytesToCopy;
            }
        }

        public void close() throws IOException {
            this.filePosition = 0;
            this.bufferPosition = 0;
            this.lastChunkNumberLoaded = -1;
            this.buffer = null;
            this.localCache = null;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closed IndexInput for file:{0} in index: {1}", new Object[]{this.fileKey.getFileName(), this.fileKey.getIndexName()});
            }
        }

        public long getFilePointer() {
            return this.filePosition;
        }

        public void seek(long pos) throws IOException {
            this.filePosition = (int)pos;
        }

        public long length() {
            return this.file.getSize();
        }
    }
}

