/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.InfinispanIndexInput;
import org.infinispan.lucene.InfinispanIndexOutput;
import org.infinispan.lucene.locking.BaseLockFactory;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanDirectory
extends Directory {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final Log log = LogFactory.getLog(InfinispanDirectory.class);
    volatile boolean isOpen = true;
    private final AdvancedCache<CacheKey, Object> cache;
    private final String indexName;
    private final int chunkSize;
    private final FileListCacheKey fileListCacheKey;

    public InfinispanDirectory(Cache<CacheKey, Object> cache, String indexName, LockFactory lf, int chunkSize) {
        this.cache = cache.getAdvancedCache();
        this.indexName = indexName;
        this.setLockFactory(lf);
        this.chunkSize = chunkSize;
        this.fileListCacheKey = new FileListCacheKey(indexName);
    }

    public InfinispanDirectory(Cache<CacheKey, Object> cache, String indexName, LockFactory lf) {
        this(cache, indexName, lf, 16384);
    }

    public InfinispanDirectory(Cache<CacheKey, Object> cache, String indexName, int chunkSize) {
        this(cache, indexName, new BaseLockFactory(cache, indexName), chunkSize);
    }

    public InfinispanDirectory(Cache<CacheKey, Object> cache, String indexName) {
        this(cache, indexName, new BaseLockFactory(cache, indexName), 16384);
    }

    public InfinispanDirectory(Cache<CacheKey, Object> cache) {
        this(cache, "");
    }

    public String[] list() throws IOException {
        this.checkIsOpen();
        Set<String> filesList = this.getFileList();
        String[] array = filesList.toArray(new String[0]);
        return array;
    }

    public boolean fileExists(String name) throws IOException {
        this.checkIsOpen();
        return this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).containsKey((Object)new FileCacheKey(this.indexName, name));
    }

    public long fileModified(String name) throws IOException {
        this.checkIsOpen();
        FileMetadata file = this.getFileMetadata(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getLastModified();
    }

    public void touchFile(String fileName) throws IOException {
        this.checkIsOpen();
        FileCacheKey key = new FileCacheKey(this.indexName, fileName);
        FileMetadata file = (FileMetadata)this.cache.get((Object)key);
        if (file == null) {
            throw new FileNotFoundException(fileName);
        }
        file.touch();
        this.cache.put((Object)key, (Object)file);
    }

    public void deleteFile(String name) throws IOException {
        this.checkIsOpen();
        Set<String> fileList = this.getFileList();
        boolean deleted = fileList.remove(name);
        if (deleted) {
            this.cache.put((Object)this.fileListCacheKey, fileList);
        }
        FileReadLockKey fileReadLockKey = new FileReadLockKey(this.indexName, name);
        InfinispanIndexInput.releaseReadLock(fileReadLockKey, this.cache);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removed file: {0} from index: {1}", new Object[]{name, this.indexName});
        }
    }

    public void renameFile(String from, String to) throws IOException {
        ChunkCacheKey fromChunkKey;
        Object ob;
        this.checkIsOpen();
        int i = -1;
        while ((ob = this.cache.get((Object)(fromChunkKey = new ChunkCacheKey(this.indexName, from, ++i)))) != null) {
            ChunkCacheKey toChunkKey = new ChunkCacheKey(this.indexName, to, i);
            this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)toChunkKey, ob);
        }
        this.cache.startBatch();
        FileCacheKey fromKey = new FileCacheKey(this.indexName, from);
        FileMetadata metadata = (FileMetadata)this.cache.remove((Object)fromKey);
        this.cache.put((Object)new FileCacheKey(this.indexName, to), (Object)metadata);
        Set<String> fileList = this.getFileList();
        fileList.remove(from);
        fileList.add(to);
        this.createRefCountForNewFile(to);
        this.cache.put((Object)this.fileListCacheKey, fileList);
        this.cache.endBatch(true);
        FileReadLockKey fileFromReadLockKey = new FileReadLockKey(this.indexName, from);
        InfinispanIndexInput.releaseReadLock(fileFromReadLockKey, this.cache);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Renamed file from: {0} to: {1} in index {2}", new Object[]{from, to, this.indexName});
        }
    }

    public long fileLength(String name) throws IOException {
        this.checkIsOpen();
        FileMetadata file = this.getFileMetadata(name);
        if (file == null) {
            throw new FileNotFoundException(name);
        }
        return file.getSize();
    }

    public IndexOutput createOutput(String name) throws IOException {
        FileCacheKey key = new FileCacheKey(this.indexName, name);
        FileMetadata newFileMetadata = new FileMetadata();
        FileMetadata previous = (FileMetadata)this.cache.putIfAbsent((Object)key, (Object)newFileMetadata);
        if (previous == null) {
            this.createRefCountForNewFile(name);
            Set<String> fileList = this.getFileList();
            fileList.add(name);
            this.cache.put((Object)this.fileListCacheKey, fileList);
            return new InfinispanIndexOutput(this.cache, key, this.chunkSize, newFileMetadata);
        }
        return new InfinispanIndexOutput(this.cache, key, this.chunkSize, previous);
    }

    private void createRefCountForNewFile(String fileName) {
        FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, fileName);
        this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)readLockKey, (Object)1);
    }

    private Set<String> getFileList() {
        Set fileList = (Set)this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)this.fileListCacheKey);
        if (fileList == null) {
            fileList = new ConcurrentHashSet();
        }
        return fileList;
    }

    public IndexInput openInput(String name) throws IOException {
        FileCacheKey fileKey = new FileCacheKey(this.indexName, name);
        return new InfinispanIndexInput(this.cache, fileKey, this.chunkSize);
    }

    public void close() throws IOException {
        this.isOpen = false;
    }

    private void checkIsOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }

    private FileMetadata getFileMetadata(String fileName) {
        FileCacheKey key = new FileCacheKey(this.indexName, fileName);
        return (FileMetadata)this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key);
    }

    public String toString() {
        return "InfinispanDirectory{indexName='" + this.indexName + '\'' + '}';
    }

    public Cache<CacheKey, Object> getCache() {
        return this.cache;
    }

    public String[] listAll() throws IOException {
        return this.list();
    }
}

