/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexInput
extends IndexInput {
    private static final Log log = LogFactory.getLog(InfinispanIndexInput.class);
    private final AdvancedCache<CacheKey, Object> cache;
    private final FileMetadata file;
    private final FileCacheKey fileKey;
    private final int chunkSize;
    private final FileReadLockKey readLockKey;
    private int currentBufferSize;
    private byte[] buffer;
    private int bufferPosition;
    private int currentLoadedChunk = -1;
    private boolean isClone;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InfinispanIndexInput(AdvancedCache<CacheKey, Object> cache, FileCacheKey fileKey, int chunkSize) throws FileNotFoundException {
        this.cache = cache;
        this.fileKey = fileKey;
        this.chunkSize = chunkSize;
        String filename = fileKey.getFileName();
        this.readLockKey = new FileReadLockKey(fileKey.getIndexName(), filename);
        boolean failure = true;
        this.aquireReadLock();
        try {
            this.file = (FileMetadata)cache.get((Object)fileKey);
            if (this.file == null) {
                throw new FileNotFoundException("Error loading medatada for index file: " + fileKey);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Opened new IndexInput for file:{0} in index: {1}", new Object[]{filename, fileKey.getIndexName()});
            }
            failure = false;
        }
        finally {
            if (failure) {
                this.releaseReadLock();
            }
        }
    }

    private void releaseReadLock() {
        InfinispanIndexInput.releaseReadLock(this.readLockKey, this.cache);
    }

    static void releaseReadLock(FileReadLockKey readLockKey, AdvancedCache<CacheKey, Object> cache) {
        int newValue = 0;
        boolean done = false;
        while (!done) {
            Object lockValue = cache.get((Object)readLockKey);
            if (lockValue == null) {
                return;
            }
            int refCount = (Integer)lockValue;
            newValue = refCount - 1;
            done = cache.replace((Object)readLockKey, (Object)refCount, (Object)newValue);
        }
        if (newValue == 0) {
            InfinispanIndexInput.realFileDelete(readLockKey, cache);
        }
    }

    static void realFileDelete(FileReadLockKey readLockKey, AdvancedCache<CacheKey, Object> cache) {
        Object removed;
        String indexName = readLockKey.getIndexName();
        String filename = readLockKey.getFileName();
        int i = 0;
        ChunkCacheKey chunkKey = new ChunkCacheKey(indexName, filename, i);
        do {
            removed = cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).remove((Object)chunkKey);
            chunkKey = new ChunkCacheKey(indexName, filename, ++i);
        } while (removed != null);
        cache.startBatch();
        cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).remove((Object)readLockKey);
        FileCacheKey key = new FileCacheKey(indexName, filename);
        cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).remove((Object)key);
        cache.endBatch(true);
    }

    private void aquireReadLock() throws FileNotFoundException {
        boolean done = false;
        while (!done) {
            Object lockValue = this.cache.get((Object)this.readLockKey);
            if (lockValue == null) {
                return;
            }
            int refCount = (Integer)lockValue;
            if (refCount == 0) {
                throw new FileNotFoundException("segment file was deleted");
            }
            Integer newValue = refCount + 1;
            done = this.cache.replace((Object)this.readLockKey, (Object)refCount, (Object)newValue);
        }
    }

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.currentBufferSize) {
            this.nextChunk();
            this.bufferPosition = 0;
        }
        return this.buffer[this.bufferPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        int bytesToRead = len;
        if (this.buffer == null) {
            this.nextChunk();
        }
        while (bytesToRead > 0) {
            int bytesToCopy = Math.min(this.currentBufferSize - this.bufferPosition, bytesToRead);
            System.arraycopy(this.buffer, this.bufferPosition, b, offset, bytesToCopy);
            offset += bytesToCopy;
            this.bufferPosition += bytesToCopy;
            if (this.bufferPosition < this.currentBufferSize || (bytesToRead -= bytesToCopy) <= 0) continue;
            this.nextChunk();
            this.bufferPosition = 0;
        }
    }

    public void close() throws IOException {
        this.currentBufferSize = 0;
        this.bufferPosition = 0;
        this.currentLoadedChunk = -1;
        this.buffer = null;
        if (this.isClone) {
            return;
        }
        this.releaseReadLock();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closed IndexInput for file:{0} in index: {1}", new Object[]{this.fileKey.getFileName(), this.fileKey.getIndexName()});
        }
    }

    public long getFilePointer() {
        return (long)this.currentLoadedChunk * (long)this.chunkSize + (long)this.bufferPosition;
    }

    public void seek(long pos) throws IOException {
        this.bufferPosition = (int)(pos % (long)this.chunkSize);
        int targetChunk = (int)(pos / (long)this.chunkSize);
        if (targetChunk != this.currentLoadedChunk) {
            this.currentLoadedChunk = targetChunk;
            this.setBufferToCurrentChunkIfPossible();
        }
    }

    private void nextChunk() throws IOException {
        ++this.currentLoadedChunk;
        this.setBufferToCurrentChunk();
    }

    private void setBufferToCurrentChunk() throws IOException {
        ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.fileKey.getFileName(), this.currentLoadedChunk);
        this.buffer = (byte[])this.cache.get((Object)key);
        if (this.buffer == null) {
            throw new IOException("Chunk value could not be found for key " + key);
        }
        this.currentBufferSize = this.buffer.length;
    }

    private void setBufferToCurrentChunkIfPossible() throws IOException {
        ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.fileKey.getFileName(), this.currentLoadedChunk);
        this.buffer = (byte[])this.cache.get((Object)key);
        if (this.buffer == null) {
            --this.currentLoadedChunk;
            this.bufferPosition = this.chunkSize;
        } else {
            this.currentBufferSize = this.buffer.length;
        }
    }

    public long length() {
        return this.file.getSize();
    }

    public Object clone() {
        InfinispanIndexInput clone = (InfinispanIndexInput)((Object)super.clone());
        clone.isClone = true;
        return clone;
    }
}

