/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.CacheKey;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexOutput
extends IndexOutput {
    private static final Log log = LogFactory.getLog(InfinispanIndexOutput.class);
    private final int bufferSize;
    private final AdvancedCache<CacheKey, Object> cache;
    private final FileMetadata file;
    private final FileCacheKey fileKey;
    private byte[] buffer;
    private int bufferPosition = 0;
    private int filePosition = 0;
    private int chunkNumber;

    public InfinispanIndexOutput(AdvancedCache<CacheKey, Object> cache, FileCacheKey fileKey, int bufferSize, FileMetadata fileMetadata) throws IOException {
        this.cache = cache;
        this.fileKey = fileKey;
        this.bufferSize = bufferSize;
        this.buffer = new byte[this.bufferSize];
        this.file = fileMetadata;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Opened new IndexOutput for file:{0} in index: {1}", new Object[]{fileKey.getFileName(), fileKey.getIndexName()});
        }
    }

    private static byte[] getChunkFromPosition(AdvancedCache<CacheKey, Object> cache, FileCacheKey fileKey, int pos, int bufferSize) {
        ChunkCacheKey key = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), InfinispanIndexOutput.getChunkNumberFromPosition(pos, bufferSize));
        return (byte[])cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key);
    }

    private static int getPositionInBuffer(int pos, int bufferSize) {
        return pos % bufferSize;
    }

    private static int getChunkNumberFromPosition(int pos, int bufferSize) {
        return pos / bufferSize;
    }

    private void newChunk() throws IOException {
        this.flush();
        this.buffer = InfinispanIndexOutput.getChunkFromPosition(this.cache, this.fileKey, this.filePosition, this.bufferSize);
        if (this.buffer == null) {
            this.buffer = new byte[this.bufferSize];
        }
        this.bufferPosition = 0;
    }

    public void writeByte(byte b) throws IOException {
        if (this.isNewChunkNeeded()) {
            this.newChunk();
        }
        this.buffer[this.bufferPosition++] = b;
        ++this.filePosition;
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        int pieceLength;
        for (int writedBytes = 0; writedBytes < length; writedBytes += pieceLength) {
            pieceLength = Math.min(this.buffer.length - this.bufferPosition, length - writedBytes);
            System.arraycopy(b, offset + writedBytes, this.buffer, this.bufferPosition, pieceLength);
            this.bufferPosition += pieceLength;
            this.filePosition += pieceLength;
            if (!this.isNewChunkNeeded()) continue;
            this.newChunk();
        }
    }

    private boolean isNewChunkNeeded() {
        return this.bufferPosition == this.buffer.length;
    }

    public void flush() throws IOException {
        this.chunkNumber = InfinispanIndexOutput.getChunkNumberFromPosition(this.filePosition - 1, this.bufferSize);
        ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.fileKey.getFileName(), this.chunkNumber);
        this.file.touch();
        if (this.file.getSize() < (long)this.filePosition) {
            this.file.setSize(this.filePosition);
        }
        this.cache.startBatch();
        this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)key, (Object)this.buffer);
        this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).put((Object)this.fileKey, (Object)this.file);
        this.cache.endBatch(true);
    }

    public void close() throws IOException {
        this.flush();
        this.bufferPosition = 0;
        this.filePosition = 0;
        this.buffer = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Closed IndexOutput for file:{0} in index: {1}", new Object[]{this.fileKey.getFileName(), this.fileKey.getIndexName()});
        }
    }

    public long getFilePointer() {
        return this.filePosition;
    }

    public void seek(long pos) throws IOException {
        this.flush();
        if (pos > this.file.getSize()) {
            throw new IOException(this.fileKey.getFileName() + ": seeking past of the file");
        }
        this.buffer = InfinispanIndexOutput.getChunkFromPosition(this.cache, this.fileKey, (int)pos, this.bufferSize);
        this.bufferPosition = InfinispanIndexOutput.getPositionInBuffer((int)pos, this.bufferSize);
        this.filePosition = (int)pos;
    }

    public long length() throws IOException {
        return this.file.getSize();
    }
}

