/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.FileNotFoundException;
import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.util.concurrent.ConcurrentHashSet;

class FileListOperations {
    private final FileListCacheKey fileListCacheKey;
    private final AdvancedCache cache;
    private final String indexName;

    FileListOperations(AdvancedCache cache, String indexName) {
        this.cache = cache;
        this.indexName = indexName;
        this.fileListCacheKey = new FileListCacheKey(indexName);
    }

    Set<String> getFileList() {
        Set fileList = (Set)this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)this.fileListCacheKey);
        if (fileList == null) {
            fileList = new ConcurrentHashSet();
        }
        return fileList;
    }

    void deleteFileName(String fileName) {
        Set<String> fileList = this.getFileList();
        boolean done = fileList.remove(fileName);
        if (done) {
            this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).put((Object)this.fileListCacheKey, fileList);
        }
    }

    void addFileName(String fileName) {
        Set<String> fileList = this.getFileList();
        boolean done = fileList.add(fileName);
        if (done) {
            this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).put((Object)this.fileListCacheKey, fileList);
        }
    }

    FileMetadata getFileMetadata(String fileName) throws FileNotFoundException {
        FileCacheKey key = new FileCacheKey(this.indexName, fileName);
        FileMetadata metadata = (FileMetadata)this.cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key);
        if (metadata == null) {
            throw new FileNotFoundException(fileName);
        }
        return metadata;
    }

    void removeAndAdd(String toRemove, String toAdd) {
        Set<String> fileList = this.getFileList();
        boolean doneAdd = fileList.add(toAdd);
        boolean doneRemove = fileList.remove(toRemove);
        if (doneAdd || doneRemove) {
            this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).put((Object)this.fileListCacheKey, fileList);
        }
    }
}

