/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListOperations;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexOutput
extends IndexOutput {
    private static final Log log = LogFactory.getLog(InfinispanIndexOutput.class);
    private final int bufferSize;
    private final AdvancedCache cache;
    private final FileMetadata file;
    private final FileCacheKey fileKey;
    private final FileListOperations fileOps;
    private final boolean trace;
    private byte[] buffer;
    private int positionInBuffer = 0;
    private long filePosition = 0L;
    private int currentChunkNumber = 0;
    private boolean needsAddingToFileList = true;
    private boolean transactionRunning = false;

    public InfinispanIndexOutput(AdvancedCache cache, FileCacheKey fileKey, int bufferSize, FileListOperations fileList) throws IOException {
        this.cache = cache;
        this.fileKey = fileKey;
        this.bufferSize = bufferSize;
        this.fileOps = fileList;
        this.buffer = new byte[this.bufferSize];
        this.file = new FileMetadata();
        this.file.setBufferSize(bufferSize);
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)"Opened new IndexOutput for file:{0} in index: {1}", new Object[]{fileKey.getFileName(), fileKey.getIndexName()});
        }
    }

    private static byte[] getChunkById(AdvancedCache cache, FileCacheKey fileKey, int chunkNumber, int bufferSize) {
        ChunkCacheKey key = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), chunkNumber);
        byte[] readBuffer = (byte[])cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key);
        if (readBuffer == null) {
            return new byte[bufferSize];
        }
        if (readBuffer.length == bufferSize) {
            return readBuffer;
        }
        byte[] newBuffer = new byte[bufferSize];
        System.arraycopy(readBuffer, 0, newBuffer, 0, readBuffer.length);
        return newBuffer;
    }

    private static int getPositionInBuffer(long pos, int bufferSize) {
        return (int)(pos % (long)bufferSize);
    }

    private static int getChunkNumberFromPosition(long pos, int bufferSize) {
        return (int)(pos / (long)bufferSize);
    }

    private void newChunk() throws IOException {
        this.doFlush();
        ++this.currentChunkNumber;
        this.buffer = InfinispanIndexOutput.getChunkById(this.cache, this.fileKey, this.currentChunkNumber, this.bufferSize);
        this.positionInBuffer = 0;
    }

    public void writeByte(byte b) throws IOException {
        if (this.isNewChunkNeeded()) {
            this.newChunk();
        }
        this.buffer[this.positionInBuffer++] = b;
        ++this.filePosition;
    }

    public void writeBytes(byte[] b, int offset, int length) throws IOException {
        int pieceLength;
        for (int writtenBytes = 0; writtenBytes < length; writtenBytes += pieceLength) {
            pieceLength = Math.min(this.bufferSize - this.positionInBuffer, length - writtenBytes);
            System.arraycopy(b, offset + writtenBytes, this.buffer, this.positionInBuffer, pieceLength);
            this.positionInBuffer += pieceLength;
            this.filePosition += (long)pieceLength;
            if (!this.isNewChunkNeeded()) continue;
            this.newChunk();
        }
    }

    private boolean isNewChunkNeeded() {
        return this.positionInBuffer == this.buffer.length;
    }

    public void flush() throws IOException {
        if (!this.transactionRunning) {
            this.transactionRunning = this.cache.startBatch();
        }
        this.doFlush();
    }

    public void doFlush() throws IOException {
        int newBufferSize;
        ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.fileKey.getFileName(), this.currentChunkNumber);
        this.file.touch();
        this.resizeFileIfNeeded();
        byte[] bufferToFlush = this.buffer;
        if (this.isWritingOnLastChunk() && (newBufferSize = (int)(this.file.getSize() % (long)this.bufferSize)) != 0) {
            bufferToFlush = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, bufferToFlush, 0, newBufferSize);
        }
        boolean microbatch = false;
        if (!this.transactionRunning) {
            microbatch = this.cache.startBatch();
        }
        this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).put((Object)key, (Object)bufferToFlush);
        this.cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).put((Object)this.fileKey, (Object)this.file);
        this.registerToFileListIfNeeded();
        if (microbatch) {
            this.cache.endBatch(true);
        }
    }

    private void registerToFileListIfNeeded() {
        if (this.needsAddingToFileList) {
            this.fileOps.addFileName(this.fileKey.getFileName());
            this.needsAddingToFileList = false;
        }
    }

    private void resizeFileIfNeeded() {
        if (this.file.getSize() < this.filePosition) {
            this.file.setSize(this.filePosition);
        }
    }

    public void close() throws IOException {
        this.doFlush();
        if (this.transactionRunning) {
            this.cache.endBatch(true);
            this.transactionRunning = false;
        }
        this.positionInBuffer = 0;
        this.filePosition = 0L;
        this.buffer = null;
        if (this.trace) {
            log.trace((Object)"Closed IndexOutput for file:{0} in index: {1}", new Object[]{this.fileKey.getFileName(), this.fileKey.getIndexName()});
        }
    }

    public long getFilePointer() {
        return this.filePosition;
    }

    public void seek(long pos) throws IOException {
        int requestedChunkNumber = InfinispanIndexOutput.getChunkNumberFromPosition(pos, this.bufferSize);
        if (pos > this.file.getSize()) {
            this.resizeFileIfNeeded();
            if (pos > this.file.getSize()) {
                throw new IOException(this.fileKey.getFileName() + ": seeking past of the file");
            }
        }
        if (requestedChunkNumber != this.currentChunkNumber) {
            this.doFlush();
            this.buffer = InfinispanIndexOutput.getChunkById(this.cache, this.fileKey, requestedChunkNumber, this.bufferSize);
            this.currentChunkNumber = requestedChunkNumber;
        }
        this.positionInBuffer = InfinispanIndexOutput.getPositionInBuffer(pos, this.bufferSize);
        this.filePosition = pos;
    }

    public long length() throws IOException {
        return this.file.getSize();
    }

    private boolean isWritingOnLastChunk() {
        int lastChunkNumber = (int)(this.file.getSize() / (long)this.bufferSize);
        return this.currentChunkNumber == lastChunkNumber;
    }
}

