/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;

public class SingleChunkIndexInput
extends IndexInput {
    private final byte[] buffer;
    private int bufferPosition;

    public SingleChunkIndexInput(AdvancedCache cache, FileCacheKey fileKey, FileMetadata fileMetadata) throws FileNotFoundException {
        ChunkCacheKey key = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), 0);
        this.buffer = (byte[])cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key);
        if (this.buffer == null) {
            throw new FileNotFoundException("Chunk value could not be found for key " + key);
        }
        this.bufferPosition = 0;
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.bufferPosition;
    }

    public long length() {
        return this.buffer.length;
    }

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.buffer.length) {
            throw new IOException("Read past EOF");
        }
        return this.buffer[this.bufferPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        len = Math.min(len, this.buffer.length - this.bufferPosition);
        System.arraycopy(this.buffer, this.bufferPosition, b, offset, len);
        this.bufferPosition += len;
    }

    public void seek(long pos) throws IOException {
        this.bufferPosition = (int)Math.min(pos, (long)this.buffer.length);
    }
}

