/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.Serializable;

public final class FileMetadata
implements Serializable {
    private static final long serialVersionUID = -7150923427362644166L;
    private long lastModified;
    private long size = 0L;
    private int bufferSize;

    public FileMetadata() {
        this.touch();
    }

    public void touch() {
        this.setLastModified(System.currentTimeMillis());
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getNumberOfChunks() {
        if (this.size % (long)this.bufferSize == 0L) {
            return (int)this.size / this.bufferSize;
        }
        return (int)(this.size / (long)this.bufferSize) + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || FileMetadata.class != o.getClass()) {
            return false;
        }
        FileMetadata metadata = (FileMetadata)o;
        return this.lastModified == metadata.lastModified && this.size == metadata.size && this.bufferSize == metadata.bufferSize;
    }

    public int hashCode() {
        int result = (int)(this.lastModified ^ this.lastModified >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public String toString() {
        return "FileMetadata{lastModified=" + this.lastModified + ", size=" + this.size + '}';
    }
}

