/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListOperations;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanIndexOutput
extends IndexOutput {
    private static final Log log = LogFactory.getLog(InfinispanIndexOutput.class);
    private final int bufferSize;
    private final AdvancedCache chunksCache;
    private final AdvancedCache metadataCache;
    private final FileMetadata file;
    private final FileCacheKey fileKey;
    private final FileListOperations fileOps;
    private final boolean trace;
    private byte[] buffer;
    private int positionInBuffer = 0;
    private long filePosition = 0L;
    private int currentChunkNumber = 0;
    private boolean needsAddingToFileList = true;

    public InfinispanIndexOutput(AdvancedCache metadataCache, AdvancedCache chunksCache, FileCacheKey fileKey, int bufferSize, FileListOperations fileList) throws IOException {
        this.metadataCache = metadataCache;
        this.chunksCache = chunksCache;
        this.fileKey = fileKey;
        this.bufferSize = bufferSize;
        this.fileOps = fileList;
        this.buffer = new byte[this.bufferSize];
        this.file = new FileMetadata();
        this.file.setBufferSize(bufferSize);
        this.trace = log.isTraceEnabled();
        if (this.trace) {
            log.trace((Object)"Opened new IndexOutput for file:{0} in index: {1}", new Object[]{fileKey.getFileName(), fileKey.getIndexName()});
        }
    }

    private static byte[] getChunkById(AdvancedCache cache, FileCacheKey fileKey, int chunkNumber, int bufferSize, FileMetadata file) {
        if (file.getNumberOfChunks() <= chunkNumber) {
            return new byte[bufferSize];
        }
        ChunkCacheKey key = new ChunkCacheKey(fileKey.getIndexName(), fileKey.getFileName(), chunkNumber);
        byte[] readBuffer = (byte[])cache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)key);
        if (readBuffer == null) {
            return new byte[bufferSize];
        }
        if (readBuffer.length == bufferSize) {
            return readBuffer;
        }
        byte[] newBuffer = new byte[bufferSize];
        System.arraycopy(readBuffer, 0, newBuffer, 0, readBuffer.length);
        return newBuffer;
    }

    private static int getPositionInBuffer(long pos, int bufferSize) {
        return (int)(pos % (long)bufferSize);
    }

    private static int getChunkNumberFromPosition(long pos, int bufferSize) {
        return (int)(pos / (long)bufferSize);
    }

    private void newChunk() throws IOException {
        this.storeCurrentBuffer();
        ++this.currentChunkNumber;
        this.buffer = InfinispanIndexOutput.getChunkById(this.chunksCache, this.fileKey, this.currentChunkNumber, this.bufferSize, this.file);
        this.positionInBuffer = 0;
    }

    public final void writeByte(byte b) throws IOException {
        if (this.isNewChunkNeeded()) {
            this.newChunk();
        }
        this.buffer[this.positionInBuffer++] = b;
        ++this.filePosition;
    }

    public final void writeBytes(byte[] b, int offset, int length) throws IOException {
        int pieceLength;
        for (int writtenBytes = 0; writtenBytes < length; writtenBytes += pieceLength) {
            if (this.isNewChunkNeeded()) {
                this.newChunk();
            }
            pieceLength = Math.min(this.bufferSize - this.positionInBuffer, length - writtenBytes);
            System.arraycopy(b, offset + writtenBytes, this.buffer, this.positionInBuffer, pieceLength);
            this.positionInBuffer += pieceLength;
            this.filePosition += (long)pieceLength;
        }
    }

    private boolean isNewChunkNeeded() {
        return this.positionInBuffer == this.buffer.length;
    }

    public void flush() throws IOException {
        this.storeCurrentBuffer();
    }

    protected void storeCurrentBuffer() throws IOException {
        int newBufferSize;
        this.resizeFileIfNeeded();
        byte[] bufferToFlush = this.buffer;
        boolean writingOnLastChunk = this.isWritingOnLastChunk();
        if (writingOnLastChunk && (newBufferSize = (int)(this.file.getSize() % (long)this.bufferSize)) != 0) {
            bufferToFlush = new byte[newBufferSize];
            System.arraycopy(this.buffer, 0, bufferToFlush, 0, newBufferSize);
        }
        boolean microbatch = false;
        if (!writingOnLastChunk || this.positionInBuffer != 0) {
            if (this.chunksCache == this.metadataCache) {
                microbatch = this.chunksCache.startBatch();
            }
            ChunkCacheKey key = new ChunkCacheKey(this.fileKey.getIndexName(), this.fileKey.getFileName(), this.currentChunkNumber);
            if (this.trace) {
                log.trace((Object)("Storing segment chunk: " + key));
            }
            this.chunksCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).put((Object)key, (Object)bufferToFlush);
        }
        this.file.touch();
        this.metadataCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).put((Object)this.fileKey, (Object)this.file);
        this.registerToFileListIfNeeded();
        if (microbatch) {
            this.chunksCache.endBatch(true);
        }
    }

    private void registerToFileListIfNeeded() {
        if (this.needsAddingToFileList) {
            this.fileOps.addFileName(this.fileKey.getFileName());
            this.needsAddingToFileList = false;
        }
    }

    private void resizeFileIfNeeded() {
        if (this.file.getSize() < this.filePosition) {
            this.file.setSize(this.filePosition);
        }
    }

    public void close() throws IOException {
        this.storeCurrentBuffer();
        this.positionInBuffer = 0;
        this.filePosition = 0L;
        this.buffer = null;
        if (this.trace) {
            log.trace((Object)"Closed IndexOutput for file:{0} in index: {1}", new Object[]{this.fileKey.getFileName(), this.fileKey.getIndexName()});
        }
    }

    public long getFilePointer() {
        return this.filePosition;
    }

    public void seek(long pos) throws IOException {
        int requestedChunkNumber = InfinispanIndexOutput.getChunkNumberFromPosition(pos, this.bufferSize);
        if (pos > this.file.getSize()) {
            this.resizeFileIfNeeded();
            if (pos > this.file.getSize()) {
                throw new IOException(this.fileKey.getFileName() + ": seeking past end of file");
            }
        }
        if (requestedChunkNumber != this.currentChunkNumber) {
            this.storeCurrentBuffer();
            this.buffer = InfinispanIndexOutput.getChunkById(this.chunksCache, this.fileKey, requestedChunkNumber, this.bufferSize, this.file);
            this.currentChunkNumber = requestedChunkNumber;
        }
        this.positionInBuffer = InfinispanIndexOutput.getPositionInBuffer(pos, this.bufferSize);
        this.filePosition = pos;
    }

    public long length() throws IOException {
        return this.file.getSize();
    }

    private boolean isWritingOnLastChunk() {
        int lastChunkNumber = this.file.getNumberOfChunks() - 1;
        return this.currentChunkNumber >= lastChunkNumber;
    }
}

