/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedSegmentReadLocker
implements SegmentReadLocker {
    private static final Log log = LogFactory.getLog(DistributedSegmentReadLocker.class);
    private final AdvancedCache locksCache;
    private final AdvancedCache chunksCache;
    private final AdvancedCache metadataCache;
    private final String indexName;

    public DistributedSegmentReadLocker(Cache locksCache, Cache chunksCache, Cache metadataCache, String indexName) {
        if (locksCache == null) {
            throw new IllegalArgumentException("locksCache must not be null");
        }
        if (chunksCache == null) {
            throw new IllegalArgumentException("chunksCache must not be null");
        }
        if (metadataCache == null) {
            throw new IllegalArgumentException("metadataCache must not be null");
        }
        if (indexName == null) {
            throw new IllegalArgumentException("index name must not be null");
        }
        this.indexName = indexName;
        this.locksCache = locksCache.getAdvancedCache();
        this.chunksCache = chunksCache.getAdvancedCache();
        this.metadataCache = metadataCache.getAdvancedCache();
        DistributedSegmentReadLocker.verifyCacheHasnoEviction(this.locksCache);
    }

    public DistributedSegmentReadLocker(Cache cache, String indexName) {
        this(cache, cache, cache, indexName);
    }

    @Override
    public void deleteOrReleaseReadLock(String filename) {
        FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, filename);
        int newValue = 0;
        boolean done = false;
        Object lockValue = this.locksCache.withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.SKIP_CACHE_STORE}).get((Object)readLockKey);
        while (!done) {
            if (lockValue == null) {
                lockValue = this.locksCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).putIfAbsent((Object)readLockKey, (Object)0);
                done = null == lockValue;
                continue;
            }
            int refCount = (Integer)lockValue;
            newValue = refCount - 1;
            done = this.locksCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).replace((Object)readLockKey, (Object)refCount, (Object)newValue);
            if (done) continue;
            lockValue = this.locksCache.withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.SKIP_CACHE_STORE}).get((Object)readLockKey);
        }
        if (newValue == 0) {
            DistributedSegmentReadLocker.realFileDelete(readLockKey, this.locksCache, this.chunksCache, this.metadataCache);
        }
    }

    @Override
    public boolean aquireReadLock(String filename) {
        FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, filename);
        Object lockValue = this.locksCache.withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.SKIP_CACHE_STORE}).get((Object)readLockKey);
        boolean done = false;
        while (!done) {
            FileCacheKey fileKey;
            if (lockValue != null) {
                int refCount = (Integer)lockValue;
                if (refCount == 0) {
                    return false;
                }
                Integer newValue = refCount + 1;
                done = this.locksCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).replace((Object)readLockKey, lockValue, (Object)newValue);
                if (done) continue;
                lockValue = this.locksCache.withFlags(new Flag[]{Flag.SKIP_LOCKING, Flag.SKIP_CACHE_STORE}).get((Object)readLockKey);
                continue;
            }
            lockValue = this.locksCache.withFlags(new Flag[]{Flag.SKIP_CACHE_STORE}).putIfAbsent((Object)readLockKey, (Object)2);
            done = null == lockValue;
            if (!done || this.metadataCache.get((Object)(fileKey = new FileCacheKey(this.indexName, filename))) != null) continue;
            this.locksCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)readLockKey);
            return false;
        }
        return true;
    }

    static void realFileDelete(FileReadLockKey readLockKey, AdvancedCache locksCache, AdvancedCache chunksCache, AdvancedCache metadataCache) {
        FileMetadata file;
        boolean trace = log.isTraceEnabled();
        String indexName = readLockKey.getIndexName();
        String filename = readLockKey.getFileName();
        FileCacheKey key = new FileCacheKey(indexName, filename);
        if (trace) {
            log.trace((Object)("deleting metadata: " + key));
        }
        if ((file = (FileMetadata)metadataCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).remove((Object)key)) != null) {
            for (int i = 0; i < file.getNumberOfChunks(); ++i) {
                ChunkCacheKey chunkKey = new ChunkCacheKey(indexName, filename, i);
                if (trace) {
                    log.trace((Object)("deleting chunk: " + chunkKey));
                }
                chunksCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_LOCKING}).removeAsync((Object)chunkKey);
            }
        }
        if (trace) {
            log.trace((Object)("deleting readlock: " + readLockKey));
        }
        locksCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)readLockKey);
    }

    private static void verifyCacheHasnoEviction(AdvancedCache cache) {
        if (cache.getConfiguration().getEvictionStrategy().isEnabled()) {
            throw new IllegalArgumentException("DistributedSegmentReadLocker is not reliable when using a cache with eviction enabled, disable eviction on this cache instance");
        }
    }
}

