/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListOperations;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.InfinispanIndexInput;
import org.infinispan.lucene.InfinispanIndexOutput;
import org.infinispan.lucene.SingleChunkIndexInput;
import org.infinispan.lucene.locking.BaseLockFactory;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class InfinispanDirectory
extends Directory {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final Log log = LogFactory.getLog(InfinispanDirectory.class);
    volatile boolean isOpen = true;
    private final AdvancedCache metadataCache;
    private final AdvancedCache chunksCache;
    private final String indexName;
    private final int chunkSize;
    private final FileListOperations fileOps;
    private final SegmentReadLocker readLocks;

    public InfinispanDirectory(Cache metadataCache, Cache chunksCache, String indexName, LockFactory lf, int chunkSize, SegmentReadLocker readLocker) {
        InfinispanDirectory.checkNotNull(metadataCache, "metadataCache");
        InfinispanDirectory.checkNotNull(chunksCache, "chunksCache");
        InfinispanDirectory.checkNotNull(indexName, "indexName");
        InfinispanDirectory.checkNotNull(lf, "LockFactory");
        InfinispanDirectory.checkNotNull(readLocker, "SegmentReadLocker");
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be a positive integer");
        }
        this.metadataCache = metadataCache.getAdvancedCache();
        this.chunksCache = chunksCache.getAdvancedCache();
        this.indexName = indexName;
        this.setLockFactory(lf);
        this.chunkSize = chunkSize;
        this.fileOps = new FileListOperations(this.metadataCache, indexName);
        this.readLocks = readLocker;
    }

    @Deprecated
    public InfinispanDirectory(Cache cache, String indexName, LockFactory lf, int chunkSize, SegmentReadLocker readLocker) {
        this(cache, cache, indexName, lf, chunkSize, readLocker);
    }

    @Deprecated
    public InfinispanDirectory(Cache cache, String indexName, LockFactory lf, int chunkSize) {
        this(cache, indexName, lf, chunkSize, InfinispanDirectory.makeDefaultSegmentReadLocker(cache, cache, cache, indexName));
    }

    public InfinispanDirectory(Cache cache, String indexName, int chunkSize, SegmentReadLocker readLocker) {
        this(cache, cache, indexName, InfinispanDirectory.makeDefaultLockFactory(cache, indexName), chunkSize, readLocker);
    }

    public InfinispanDirectory(Cache metadataCache, Cache chunksCache, Cache distLocksCache, String indexName, int chunkSize) {
        this(metadataCache, chunksCache, indexName, InfinispanDirectory.makeDefaultLockFactory(distLocksCache, indexName), chunkSize, InfinispanDirectory.makeDefaultSegmentReadLocker(metadataCache, chunksCache, distLocksCache, indexName));
    }

    @Deprecated
    public InfinispanDirectory(Cache cache, String indexName, LockFactory lf) {
        this(cache, indexName, lf, 16384);
    }

    @Deprecated
    public InfinispanDirectory(Cache cache, String indexName, int chunkSize) {
        this(cache, indexName, InfinispanDirectory.makeDefaultLockFactory(cache, indexName), chunkSize);
    }

    public InfinispanDirectory(Cache cache, String indexName) {
        this(cache, cache, cache, indexName, 16384);
    }

    public InfinispanDirectory(Cache cache) {
        this(cache, cache, cache, "", 16384);
    }

    public String[] list() throws IOException {
        this.checkIsOpen();
        Set<String> filesList = this.fileOps.getFileList();
        String[] array = filesList.toArray(new String[0]);
        return array;
    }

    public boolean fileExists(String name) throws IOException {
        this.checkIsOpen();
        return this.fileOps.getFileList().contains(name);
    }

    public long fileModified(String name) throws IOException {
        this.checkIsOpen();
        FileMetadata fileMetadata = this.fileOps.getFileMetadata(name);
        if (fileMetadata == null) {
            return 0L;
        }
        return fileMetadata.getLastModified();
    }

    public void touchFile(String fileName) throws IOException {
        this.checkIsOpen();
        FileMetadata file = this.fileOps.getFileMetadata(fileName);
        if (file == null) {
            return;
        }
        FileCacheKey key = new FileCacheKey(this.indexName, fileName);
        file.touch();
        this.metadataCache.put((Object)key, (Object)file);
    }

    public void deleteFile(String name) throws IOException {
        this.checkIsOpen();
        this.fileOps.deleteFileName(name);
        this.readLocks.deleteOrReleaseReadLock(name);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Removed file: %s from index: %s", new Object[]{name, this.indexName});
        }
    }

    public void renameFile(String from, String to) throws IOException {
        ChunkCacheKey fromChunkKey;
        Object ob;
        this.checkIsOpen();
        int i = -1;
        while ((ob = this.chunksCache.get((Object)(fromChunkKey = new ChunkCacheKey(this.indexName, from, ++i)))) != null) {
            ChunkCacheKey toChunkKey = new ChunkCacheKey(this.indexName, to, i);
            this.chunksCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD}).put((Object)toChunkKey, ob);
        }
        boolean batching = this.metadataCache.startBatch();
        FileCacheKey fromKey = new FileCacheKey(this.indexName, from);
        FileMetadata metadata = (FileMetadata)this.metadataCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)fromKey);
        this.metadataCache.put((Object)new FileCacheKey(this.indexName, to), (Object)metadata);
        this.fileOps.removeAndAdd(from, to);
        if (batching) {
            this.metadataCache.endBatch(true);
        }
        this.readLocks.deleteOrReleaseReadLock(from);
        if (log.isTraceEnabled()) {
            log.trace((Object)"Renamed file from: %s to: %s in index %s", new Object[]{from, to, this.indexName});
        }
    }

    public long fileLength(String name) throws IOException {
        this.checkIsOpen();
        FileMetadata fileMetadata = this.fileOps.getFileMetadata(name);
        if (fileMetadata == null) {
            return 0L;
        }
        return fileMetadata.getSize();
    }

    public IndexOutput createOutput(String name) throws IOException {
        FileCacheKey key = new FileCacheKey(this.indexName, name);
        return new InfinispanIndexOutput(this.metadataCache, this.chunksCache, key, this.chunkSize, this.fileOps);
    }

    public IndexInput openInput(String name) throws IOException {
        FileCacheKey fileKey = new FileCacheKey(this.indexName, name);
        FileMetadata fileMetadata = (FileMetadata)this.metadataCache.withFlags(new Flag[]{Flag.SKIP_LOCKING}).get((Object)fileKey);
        if (fileMetadata == null) {
            throw new FileNotFoundException("Error loading medatada for index file: " + fileKey);
        }
        if (fileMetadata.getSize() <= (long)fileMetadata.getBufferSize()) {
            return new SingleChunkIndexInput(this.chunksCache, fileKey, fileMetadata);
        }
        boolean locked = this.readLocks.acquireReadLock(name);
        if (!locked) {
            throw new FileNotFoundException("Error loading medatada for index file: " + fileKey);
        }
        return new InfinispanIndexInput(this.chunksCache, fileKey, fileMetadata, this.readLocks);
    }

    public void close() throws IOException {
        this.isOpen = false;
    }

    private void checkIsOpen() throws AlreadyClosedException {
        if (!this.isOpen) {
            throw new AlreadyClosedException("this Directory is closed");
        }
    }

    public String toString() {
        return "InfinispanDirectory{indexName='" + this.indexName + '\'' + '}';
    }

    public String[] listAll() throws IOException {
        return this.list();
    }

    public String getIndexName() {
        return this.indexName;
    }

    private static LockFactory makeDefaultLockFactory(Cache cache, String indexName) {
        InfinispanDirectory.checkNotNull(cache, "cache");
        InfinispanDirectory.checkNotNull(indexName, "indexName");
        return new BaseLockFactory(cache, indexName);
    }

    private static SegmentReadLocker makeDefaultSegmentReadLocker(Cache metadataCache, Cache chunksCache, Cache distLocksCache, String indexName) {
        InfinispanDirectory.checkNotNull(distLocksCache, "distLocksCache");
        InfinispanDirectory.checkNotNull(indexName, "indexName");
        return new DistributedSegmentReadLocker(distLocksCache, chunksCache, metadataCache, indexName);
    }

    private static void checkNotNull(Object v, String objectname) {
        if (v == null) {
            throw new IllegalArgumentException(objectname + " must not be null");
        }
    }
}

