/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Set;
import org.infinispan.io.UnsignedNumeric;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public final class FileMetadata
implements Serializable {
    private static final long serialVersionUID = -7150923427362644166L;
    private long lastModified = 0L;
    private long size = 0L;
    private int bufferSize;

    public FileMetadata() {
    }

    private FileMetadata(long lastModified, long size, int bufferSize) {
        this.lastModified = lastModified;
        this.size = size;
        this.bufferSize = bufferSize;
    }

    public void touch() {
        this.setLastModified(System.currentTimeMillis());
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getNumberOfChunks() {
        if (this.size % (long)this.bufferSize == 0L) {
            return (int)this.size / this.bufferSize;
        }
        return (int)(this.size / (long)this.bufferSize) + 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || FileMetadata.class != o.getClass()) {
            return false;
        }
        FileMetadata metadata = (FileMetadata)o;
        return this.lastModified == metadata.lastModified && this.size == metadata.size && this.bufferSize == metadata.bufferSize;
    }

    public int hashCode() {
        int result = (int)(this.lastModified ^ this.lastModified >>> 32);
        result = 31 * result + (int)(this.size ^ this.size >>> 32);
        return result;
    }

    public String toString() {
        return "FileMetadata{lastModified=" + this.lastModified + ", size=" + this.size + '}';
    }

    public static class Externalizer
    extends AbstractExternalizer<FileMetadata> {
        public void writeObject(ObjectOutput output, FileMetadata metadata) throws IOException {
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)metadata.lastModified);
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)metadata.size);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)metadata.bufferSize);
        }

        public FileMetadata readObject(ObjectInput input) throws IOException {
            long lastModified = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            long size = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            int bufferSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            return new FileMetadata(lastModified, size, bufferSize);
        }

        public Integer getId() {
            return 1301;
        }

        public Set<Class<? extends FileMetadata>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{FileMetadata.class});
        }
    }
}

