/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import java.util.concurrent.ConcurrentHashMap;
import org.infinispan.Cache;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;

public class LocalLockMergingSegmentReadLocker
implements SegmentReadLocker {
    private final ConcurrentHashMap<String, LocalReadLock> localLocks = new ConcurrentHashMap();
    private final DistributedSegmentReadLocker delegate;

    public LocalLockMergingSegmentReadLocker(Cache cache, String indexName) {
        this.delegate = new DistributedSegmentReadLocker(cache, cache, cache, indexName);
    }

    public LocalLockMergingSegmentReadLocker(Cache locksCache, Cache chunksCache, Cache metadataCache, String indexName) {
        this.delegate = new DistributedSegmentReadLocker(locksCache, chunksCache, metadataCache, indexName);
    }

    @Override
    public boolean acquireReadLock(String name) {
        LocalReadLock localReadLock = this.getLocalLockByName(name);
        boolean acquired = localReadLock.acquire();
        if (acquired) {
            return true;
        }
        this.localLocks.remove(name);
        return false;
    }

    private LocalReadLock getLocalLockByName(String name) {
        LocalReadLock localReadLock = this.localLocks.get(name);
        if (localReadLock == null) {
            LocalReadLock newReadLock = new LocalReadLock(name);
            LocalReadLock prevReadLock = this.localLocks.putIfAbsent(name, newReadLock);
            localReadLock = prevReadLock == null ? newReadLock : prevReadLock;
        }
        return localReadLock;
    }

    @Override
    public void deleteOrReleaseReadLock(String name) {
        this.getLocalLockByName(name).release();
    }

    private class LocalReadLock {
        private final String name;
        private int value = 0;

        LocalReadLock(String name) {
            this.name = name;
        }

        synchronized boolean acquire() {
            if (this.value == 0) {
                boolean haveIt = LocalLockMergingSegmentReadLocker.this.delegate.acquireReadLock(this.name);
                if (haveIt) {
                    this.value = 1;
                    return true;
                }
                this.value = -1;
                return false;
            }
            if (this.value == -1) {
                return false;
            }
            ++this.value;
            return true;
        }

        synchronized void release() {
            --this.value;
            if (this.value <= 0) {
                LocalLockMergingSegmentReadLocker.this.localLocks.remove(this.name);
                LocalLockMergingSegmentReadLocker.this.delegate.deleteOrReleaseReadLock(this.name);
            }
        }
    }
}

