/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.util.Set;
import org.infinispan.AdvancedCache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.InfinispanIndexOutput;
import org.infinispan.util.concurrent.ConcurrentHashSet;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

final class FileListOperations {
    private static final Log log = LogFactory.getLog(InfinispanIndexOutput.class);
    private static final boolean trace = log.isTraceEnabled();
    private final FileListCacheKey fileListCacheKey;
    private final AdvancedCache cache;
    private final String indexName;
    private final AdvancedCache cacheNoRetrieve;

    FileListOperations(AdvancedCache cache, String indexName) {
        this.cache = cache;
        this.cacheNoRetrieve = cache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD});
        this.indexName = indexName;
        this.fileListCacheKey = new FileListCacheKey(indexName);
    }

    Set<String> getFileList() {
        Set prev;
        Set fileList = (Set)this.cache.get((Object)this.fileListCacheKey);
        if (fileList == null && (prev = (Set)this.cache.putIfAbsent((Object)this.fileListCacheKey, (Object)(fileList = new ConcurrentHashSet()))) != null) {
            fileList = prev;
        }
        if (trace) {
            log.trace((Object)"Refreshed file listing view");
        }
        return fileList;
    }

    void deleteFileName(String fileName) {
        Set<String> fileList = this.getFileList();
        boolean done = fileList.remove(fileName);
        if (done) {
            this.cacheNoRetrieve.put((Object)this.fileListCacheKey, fileList);
            if (trace) {
                log.trace((Object)("Updated file listing: removed " + fileName));
            }
        }
    }

    void addFileName(String fileName) {
        Set<String> fileList = this.getFileList();
        boolean done = fileList.add(fileName);
        if (done) {
            this.cacheNoRetrieve.put((Object)this.fileListCacheKey, fileList);
            if (trace) {
                log.trace((Object)("Updated file listing: added " + fileName));
            }
        }
    }

    FileMetadata getFileMetadata(String fileName) {
        FileCacheKey key = new FileCacheKey(this.indexName, fileName);
        FileMetadata metadata = (FileMetadata)this.cache.get((Object)key);
        return metadata;
    }

    void removeAndAdd(String toRemove, String toAdd) {
        Set<String> fileList = this.getFileList();
        boolean doneAdd = fileList.add(toAdd);
        boolean doneRemove = fileList.remove(toRemove);
        if (doneAdd || doneRemove) {
            this.cacheNoRetrieve.put((Object)this.fileListCacheKey, fileList);
            if (trace) {
                if (doneAdd) {
                    log.trace((Object)("Updated file listing: added " + toAdd));
                }
                if (doneRemove) {
                    log.trace((Object)("Updated file listing: removed " + toRemove));
                }
            }
        }
    }
}

