/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.util.regex.Pattern;
import org.infinispan.loaders.keymappers.TwoWayKey2StringMapper;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileListCacheKey;
import org.infinispan.lucene.FileReadLockKey;

public class LuceneKey2StringMapper
implements TwoWayKey2StringMapper {
    static final Pattern singlePipePattern = Pattern.compile("\\|");

    public boolean isSupportedType(Class<?> keyType) {
        return keyType == ChunkCacheKey.class || keyType == FileCacheKey.class || keyType == FileListCacheKey.class || keyType == FileReadLockKey.class;
    }

    public String getStringMapping(Object key) {
        return key.toString();
    }

    public Object getKeyMapping(String key) {
        if (key == null) {
            throw new IllegalArgumentException("Not supporting null keys");
        }
        if (key.startsWith("*|")) {
            return new FileListCacheKey(key.substring(2));
        }
        String[] split = singlePipePattern.split(key);
        if (split.length != 3) {
            throw new IllegalArgumentException("Unexpected format of key in String form: " + key);
        }
        if ("M".equals(split[1])) {
            return new FileCacheKey(split[2], split[0]);
        }
        if ("RL".equals(split[1])) {
            return new FileReadLockKey(split[2], split[0]);
        }
        try {
            int parsedInt = Integer.parseInt(split[1]);
            return new ChunkCacheKey(split[2], split[0], parsedInt);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Unexpected format of key in String form: " + key, nfe);
        }
    }
}

