/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.FileReadLockKey;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class DistributedSegmentReadLocker
implements SegmentReadLocker {
    private static final Log log = LogFactory.getLog(DistributedSegmentReadLocker.class);
    private final AdvancedCache<Object, Integer> locksCache;
    private final AdvancedCache<?, ?> chunksCache;
    private final AdvancedCache<?, ?> metadataCache;
    private final String indexName;

    public DistributedSegmentReadLocker(Cache<Object, Integer> locksCache, Cache<?, ?> chunksCache, Cache<?, ?> metadataCache, String indexName) {
        if (locksCache == null) {
            throw new IllegalArgumentException("locksCache must not be null");
        }
        if (chunksCache == null) {
            throw new IllegalArgumentException("chunksCache must not be null");
        }
        if (metadataCache == null) {
            throw new IllegalArgumentException("metadataCache must not be null");
        }
        if (indexName == null) {
            throw new IllegalArgumentException("index name must not be null");
        }
        this.indexName = indexName;
        this.locksCache = locksCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD});
        this.chunksCache = chunksCache.getAdvancedCache();
        this.metadataCache = metadataCache.getAdvancedCache();
        DistributedSegmentReadLocker.verifyCacheHasNoEviction(this.locksCache);
    }

    public DistributedSegmentReadLocker(Cache<?, ?> cache, String indexName) {
        this(cache, cache, cache, indexName);
    }

    @Override
    public void deleteOrReleaseReadLock(String filename) {
        FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, filename);
        int newValue = 0;
        boolean done = false;
        Object lockValue = this.locksCache.get((Object)readLockKey);
        while (!done) {
            if (lockValue == null) {
                lockValue = this.locksCache.putIfAbsent((Object)readLockKey, (Object)0);
                done = null == lockValue;
                continue;
            }
            Integer refCountObject = (Integer)lockValue;
            int refCount = refCountObject;
            newValue = refCount - 1;
            done = this.locksCache.replace((Object)readLockKey, (Object)refCountObject, (Object)newValue);
            if (done) continue;
            lockValue = this.locksCache.get((Object)readLockKey);
        }
        if (newValue == 0) {
            DistributedSegmentReadLocker.realFileDelete(readLockKey, this.locksCache, this.chunksCache, this.metadataCache);
        }
    }

    @Override
    public boolean acquireReadLock(String filename) {
        FileReadLockKey readLockKey = new FileReadLockKey(this.indexName, filename);
        Integer lockValue = (Integer)this.locksCache.get((Object)readLockKey);
        boolean done = false;
        while (!done) {
            FileCacheKey fileKey;
            if (lockValue != null) {
                int refCount = lockValue;
                if (refCount == 0) {
                    return false;
                }
                Integer newValue = refCount + 1;
                done = this.locksCache.replace((Object)readLockKey, (Object)lockValue, (Object)newValue);
                if (done) continue;
                lockValue = (Integer)this.locksCache.get((Object)readLockKey);
                continue;
            }
            lockValue = (Integer)this.locksCache.putIfAbsent((Object)readLockKey, (Object)2);
            done = null == lockValue;
            if (!done || this.metadataCache.get((Object)(fileKey = new FileCacheKey(this.indexName, filename))) != null) continue;
            this.locksCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)readLockKey);
            return false;
        }
        return true;
    }

    static void realFileDelete(FileReadLockKey readLockKey, AdvancedCache<Object, Integer> locksCache, AdvancedCache<?, ?> chunksCache, AdvancedCache<?, ?> metadataCache) {
        boolean trace = log.isTraceEnabled();
        String indexName = readLockKey.getIndexName();
        String filename = readLockKey.getFileName();
        FileCacheKey key = new FileCacheKey(indexName, filename);
        if (trace) {
            log.tracef("deleting metadata: %s", (Object)key);
        }
        FileMetadata file = (FileMetadata)metadataCache.remove((Object)key);
        int bufferSize = file.getBufferSize();
        if (file != null) {
            for (int i = 0; i < file.getNumberOfChunks(); ++i) {
                ChunkCacheKey chunkKey = new ChunkCacheKey(indexName, filename, i, bufferSize);
                if (trace) {
                    log.tracef("deleting chunk: %s", (Object)chunkKey);
                }
                chunksCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP, Flag.SKIP_CACHE_LOAD}).removeAsync((Object)chunkKey);
            }
        }
        if (trace) {
            log.tracef("deleting readlock: %s", (Object)readLockKey);
        }
        locksCache.withFlags(new Flag[]{Flag.SKIP_REMOTE_LOOKUP}).removeAsync((Object)readLockKey);
    }

    private static void verifyCacheHasNoEviction(AdvancedCache<?, ?> cache) {
        if (cache.getConfiguration().getEvictionStrategy().isEnabled()) {
            throw new IllegalArgumentException("DistributedSegmentReadLocker is not reliable when using a cache with eviction enabled, disable eviction on this cache instance");
        }
    }
}

