/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Set;
import org.infinispan.lucene.ExternalizerIds;
import org.infinispan.lucene.IndexScopedKey;
import org.infinispan.lucene.KeyVisitor;
import org.infinispan.marshall.AbstractExternalizer;
import org.infinispan.util.Util;

public final class FileListCacheKey
implements Serializable,
IndexScopedKey {
    private static final long serialVersionUID = 8965108175527988255L;
    private final String indexName;
    private final int hashCode;

    public FileListCacheKey(String indexName) {
        this.indexName = indexName;
        this.hashCode = this.generatedHashCode();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public Object accept(KeyVisitor visitor) throws Exception {
        return visitor.visit(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int generatedHashCode() {
        return 31 + this.indexName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (FileListCacheKey.class != obj.getClass()) {
            return false;
        }
        FileListCacheKey other = (FileListCacheKey)obj;
        return this.indexName.equals(other.indexName);
    }

    public String toString() {
        return "*|" + this.indexName;
    }

    public static final class Externalizer
    extends AbstractExternalizer<FileListCacheKey> {
        public void writeObject(ObjectOutput output, FileListCacheKey key) throws IOException {
            output.writeUTF(key.indexName);
        }

        public FileListCacheKey readObject(ObjectInput input) throws IOException {
            String indexName = input.readUTF();
            return new FileListCacheKey(indexName);
        }

        public Integer getId() {
            return ExternalizerIds.FILE_LIST_CACHE_KEY;
        }

        public Set<Class<? extends FileListCacheKey>> getTypeClasses() {
            return Util.asSet((Object[])new Class[]{FileListCacheKey.class});
        }
    }
}

