/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.locking;

import java.io.Closeable;
import java.io.IOException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.lucene.store.Lock;
import org.infinispan.Cache;
import org.infinispan.commons.CacheException;
import org.infinispan.context.Flag;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.logging.Log;
import org.infinispan.util.logging.LogFactory;

class TransactionalSharedLuceneLock
extends Lock
implements Closeable {
    private static final Log log = (Log)LogFactory.getLog(TransactionalSharedLuceneLock.class, Log.class);
    private final Cache<FileCacheKey, FileCacheKey> noCacheStoreCache;
    private final String lockName;
    private final String indexName;
    private final TransactionManager tm;
    private final FileCacheKey keyOfLock;

    TransactionalSharedLuceneLock(Cache<?, ?> cache, String indexName, String lockName, TransactionManager tm) {
        this.noCacheStoreCache = cache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_CACHE_STORE, Flag.SKIP_CACHE_LOAD, Flag.SKIP_INDEXING});
        this.lockName = lockName;
        this.indexName = indexName;
        this.tm = tm;
        this.keyOfLock = new FileCacheKey(indexName, lockName);
    }

    public boolean obtain() throws IOException {
        Object previousValue = this.noCacheStoreCache.putIfAbsent((Object)this.keyOfLock, (Object)this.keyOfLock);
        if (previousValue == null) {
            if (log.isTraceEnabled()) {
                log.tracef("Lock: %s acquired for index: %s", this.lockName, this.indexName);
            }
            this.startTransaction();
            return true;
        }
        if (log.isTraceEnabled()) {
            log.tracef("Lock: %s not aquired for index: %s, was taken already.", this.lockName, this.indexName);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() throws IOException {
        try {
            this.commitTransactions();
        }
        finally {
            this.clearLock();
        }
    }

    private void clearLock() {
        Object previousValue = this.noCacheStoreCache.remove((Object)this.keyOfLock);
        if (previousValue != null && log.isTraceEnabled()) {
            log.tracef("Lock removed for index: %s", this.indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocked() {
        boolean locked = false;
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
            if (tx != null) {
                this.tm.suspend();
            }
            locked = this.noCacheStoreCache.containsKey((Object)this.keyOfLock);
        }
        catch (Exception e) {
            log.errorSuspendingTransaction(e);
        }
        finally {
            if (tx != null) {
                try {
                    this.tm.resume(tx);
                }
                catch (Exception e) {
                    throw new CacheException("Unable to resume suspended transaction " + tx, (Throwable)e);
                }
            }
        }
        return locked;
    }

    private void startTransaction() throws IOException {
        try {
            this.tm.begin();
        }
        catch (Exception e) {
            log.unableToStartTransaction(e);
            throw new IOException("SharedLuceneLock could not start a transaction after having acquired the lock", e);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Batch transaction started for index: %s", this.indexName);
        }
    }

    private void commitTransactions() throws IOException {
        try {
            this.tm.commit();
        }
        catch (Exception e) {
            log.unableToCommitTransaction(e);
            throw new IOException("SharedLuceneLock could not commit a transaction", e);
        }
        if (log.isTraceEnabled()) {
            log.tracef("Batch transaction commited for index: %s", this.indexName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLockSuspending() {
        Transaction tx = null;
        try {
            tx = this.tm.getTransaction();
            if (tx != null) {
                this.tm.suspend();
            }
            this.clearLock();
        }
        catch (Exception e) {
            log.errorSuspendingTransaction(e);
        }
        finally {
            if (tx != null) {
                try {
                    this.tm.resume(tx);
                }
                catch (Exception e) {
                    throw new CacheException("Unable to resume suspended transaction " + tx, (Throwable)e);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.release();
    }
}

