/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Set;
import org.apache.lucene.store.IndexOutput;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.impl.CheckSummingIndexOutput;
import org.infinispan.lucene.impl.FileListOperations;
import org.infinispan.lucene.impl.IndexInputContext;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

class DirectoryImplementor {
    private static final Log log = LogFactory.getLog(DirectoryImplementor.class);
    protected final AdvancedCache<FileCacheKey, FileMetadata> metadataCache;
    protected final AdvancedCache<ChunkCacheKey, Object> chunksCache;
    protected final String indexName;
    protected final int chunkSize;
    protected final FileListOperations fileOps;
    private final SegmentReadLocker readLocks;
    private final FileCacheKey segmentsGenFileKey;

    public DirectoryImplementor(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, String indexName, int chunkSize, SegmentReadLocker readLocker) {
        if (chunkSize <= 0) {
            throw new IllegalArgumentException("chunkSize must be a positive integer");
        }
        this.metadataCache = metadataCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        this.chunksCache = chunksCache.getAdvancedCache().withFlags(new Flag[]{Flag.SKIP_INDEXING});
        this.indexName = indexName;
        this.chunkSize = chunkSize;
        this.fileOps = new FileListOperations(this.metadataCache, indexName);
        this.segmentsGenFileKey = new FileCacheKey(indexName, "segments.gen");
        this.readLocks = readLocker;
    }

    String[] list() {
        Set<String> files = this.fileOps.getFileList();
        String[] array = files.toArray(new String[0]);
        return array;
    }

    boolean fileExists(String name) {
        return this.fileOps.getFileList().contains(name);
    }

    void deleteFile(String name) {
        this.fileOps.deleteFileName(name);
        this.readLocks.deleteOrReleaseReadLock(name);
        if (log.isDebugEnabled()) {
            log.debugf("Removed file: %s from index: %s", (Object)name, (Object)this.indexName);
        }
    }

    void renameFile(String from, String to) {
        ChunkCacheKey fromChunkKey;
        Object ob;
        FileCacheKey fromKey = new FileCacheKey(this.indexName, from);
        FileMetadata metadata = (FileMetadata)this.metadataCache.get((Object)fromKey);
        int bufferSize = metadata.getBufferSize();
        int i = -1;
        while ((ob = this.chunksCache.get((Object)(fromChunkKey = new ChunkCacheKey(this.indexName, from, ++i, bufferSize)))) != null) {
            ChunkCacheKey toChunkKey = new ChunkCacheKey(this.indexName, to, i, bufferSize);
            this.chunksCache.withFlags(new Flag[]{Flag.IGNORE_RETURN_VALUES}).put((Object)toChunkKey, ob);
        }
        this.metadataCache.put((Object)new FileCacheKey(this.indexName, to), (Object)metadata);
        this.fileOps.removeAndAdd(from, to);
        this.readLocks.deleteOrReleaseReadLock(from);
        if (log.isTraceEnabled()) {
            log.tracef("Renamed file from: %s to: %s in index %s", (Object)from, (Object)to, (Object)this.indexName);
        }
    }

    long fileLength(String name) {
        FileMetadata fileMetadata = this.fileOps.getFileMetadata(name);
        if (fileMetadata == null) {
            return 0L;
        }
        return fileMetadata.getSize();
    }

    IndexOutput createOutput(String name) {
        if ("segments.gen".equals(name)) {
            return new CheckSummingIndexOutput(this.metadataCache, this.chunksCache, this.segmentsGenFileKey, this.chunkSize, this.fileOps);
        }
        FileCacheKey key = new FileCacheKey(this.indexName, name);
        return new CheckSummingIndexOutput(this.metadataCache, this.chunksCache, key, this.chunkSize, this.fileOps);
    }

    IndexInputContext openInput(String name) throws IOException {
        FileCacheKey fileKey = new FileCacheKey(this.indexName, name);
        FileMetadata fileMetadata = (FileMetadata)this.metadataCache.get((Object)fileKey);
        if (fileMetadata == null) {
            throw new FileNotFoundException("Error loading metadata for index file: " + fileKey);
        }
        if (fileMetadata.getSize() <= (long)fileMetadata.getBufferSize()) {
            return new IndexInputContext(this.chunksCache, fileKey, fileMetadata, null);
        }
        boolean locked = this.readLocks.acquireReadLock(name);
        if (!locked) {
            throw new FileNotFoundException("Error loading metadata for index file: " + fileKey);
        }
        return new IndexInputContext(this.chunksCache, fileKey, fileMetadata, this.readLocks);
    }

    public String getIndexName() {
        return this.indexName;
    }

    public String toString() {
        return "DirectoryImplementor{indexName='" + this.indexName + "'}";
    }

    public int getChunkSize() {
        return this.chunkSize;
    }

    public Cache getMetadataCache() {
        return this.metadataCache;
    }

    public Cache getDataCache() {
        return this.chunksCache;
    }
}

