/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.lucene.directory.BuildContext;
import org.infinispan.lucene.impl.DirectoryLuceneV4;
import org.infinispan.lucene.locking.BaseLockFactory;
import org.infinispan.lucene.logging.Log;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;
import org.infinispan.util.logging.LogFactory;

public class DirectoryBuilderImpl
implements BuildContext {
    public static final int DEFAULT_BUFFER_SIZE = 16384;
    private static final Log log = (Log)LogFactory.getLog(DirectoryBuilderImpl.class, Log.class);
    private final Cache<?, ?> metadataCache;
    private final Cache<?, ?> chunksCache;
    private final Cache<?, ?> distLocksCache;
    private final String indexName;
    private int chunkSize = 16384;
    private SegmentReadLocker srl = null;
    private LockFactory lockFactory = null;

    public DirectoryBuilderImpl(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, Cache<?, ?> distLocksCache, String indexName) {
        this.metadataCache = DirectoryBuilderImpl.checkValidConfiguration(DirectoryBuilderImpl.checkNotNull(metadataCache, "metadataCache"), indexName);
        this.chunksCache = DirectoryBuilderImpl.checkValidConfiguration(DirectoryBuilderImpl.checkNotNull(chunksCache, "chunksCache"), indexName);
        this.distLocksCache = DirectoryBuilderImpl.checkValidConfiguration(DirectoryBuilderImpl.checkNotNull(distLocksCache, "distLocksCache"), indexName);
        this.indexName = DirectoryBuilderImpl.checkNotNull(indexName, "indexName");
        DirectoryBuilderImpl.validateMetadataCache(metadataCache, indexName);
    }

    @Override
    public Directory create() {
        if (this.lockFactory == null) {
            this.lockFactory = DirectoryBuilderImpl.makeDefaultLockFactory(this.distLocksCache, this.indexName);
        }
        if (this.srl == null) {
            this.srl = DirectoryBuilderImpl.makeDefaultSegmentReadLocker(this.metadataCache, this.chunksCache, this.distLocksCache, this.indexName);
        }
        return new DirectoryLuceneV4(this.metadataCache, this.chunksCache, this.indexName, this.lockFactory, this.chunkSize, this.srl);
    }

    @Override
    public BuildContext chunkSize(int bytes) {
        if (bytes <= 0) {
            throw new IllegalArgumentException("chunkSize must be a positive integer");
        }
        this.chunkSize = bytes;
        return this;
    }

    @Override
    public BuildContext overrideSegmentReadLocker(SegmentReadLocker srl) {
        DirectoryBuilderImpl.checkNotNull(srl, "srl");
        this.srl = srl;
        return this;
    }

    @Override
    public BuildContext overrideWriteLocker(LockFactory lockFactory) {
        DirectoryBuilderImpl.checkNotNull(lockFactory, "lockFactory");
        this.lockFactory = lockFactory;
        return this;
    }

    private static SegmentReadLocker makeDefaultSegmentReadLocker(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, Cache<?, ?> distLocksCache, String indexName) {
        DirectoryBuilderImpl.checkNotNull(distLocksCache, "distLocksCache");
        DirectoryBuilderImpl.checkNotNull(indexName, "indexName");
        return new DistributedSegmentReadLocker(distLocksCache, chunksCache, metadataCache, indexName);
    }

    private static <T> T checkNotNull(T v, String objectname) {
        if (v == null) {
            throw log.requiredParameterWasPassedNull(objectname);
        }
        return v;
    }

    private static Cache<?, ?> checkValidConfiguration(Cache<?, ?> cache, String indexName) {
        if (cache == null) {
            return null;
        }
        Configuration configuration = cache.getCacheConfiguration();
        if (configuration.expiration().maxIdle() != -1L) {
            throw log.luceneStorageHavingIdleTimeSet(indexName, cache.getName());
        }
        if (configuration.expiration().lifespan() != -1L) {
            throw log.luceneStorageHavingLifespanSet(indexName, cache.getName());
        }
        if (configuration.storeAsBinary().enabled()) {
            throw log.luceneStorageAsBinaryEnabled(indexName, cache.getName());
        }
        if (!Configurations.noDataLossOnJoiner((Configuration)configuration)) {
            throw log.luceneStorageNoStateTransferEnabled(indexName, cache.getName());
        }
        return cache;
    }

    private static LockFactory makeDefaultLockFactory(Cache<?, ?> cache, String indexName) {
        DirectoryBuilderImpl.checkNotNull(cache, "cache");
        DirectoryBuilderImpl.checkNotNull(indexName, "indexName");
        return new BaseLockFactory(cache, indexName);
    }

    private static void validateMetadataCache(Cache<?, ?> cache, String indexName) {
        Configuration configuration = cache.getCacheConfiguration();
        if (configuration.eviction().strategy().isEnabled()) {
            throw log.evictionNotAllowedInMetadataCache(indexName, cache.getName());
        }
        if (configuration.persistence().usingStores() && !configuration.persistence().preload().booleanValue()) {
            throw log.preloadNeededIfPersistenceIsEnabledForMetadataCache(indexName, cache.getName());
        }
    }
}

