/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.LockFactory;
import org.infinispan.Cache;
import org.infinispan.lucene.impl.DirectoryExtensions;
import org.infinispan.lucene.impl.DirectoryImplementor;
import org.infinispan.lucene.impl.IndexInputContext;
import org.infinispan.lucene.impl.InfinispanIndexInput;
import org.infinispan.lucene.impl.SingleChunkIndexInput;
import org.infinispan.lucene.readlocks.SegmentReadLocker;

class DirectoryLuceneV4
extends Directory
implements DirectoryExtensions {
    private final DirectoryImplementor impl;
    private final String indexName;
    private volatile LockFactory lockFactory;

    public DirectoryLuceneV4(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, String indexName, LockFactory lf, int chunkSize, SegmentReadLocker readLocker) {
        this.impl = new DirectoryImplementor(metadataCache, chunksCache, indexName, chunkSize, readLocker);
        this.indexName = indexName;
        this.lockFactory = lf;
        this.lockFactory.setLockPrefix(this.getLockID());
    }

    public boolean fileExists(String name) {
        this.ensureOpen();
        return this.impl.fileExists(name);
    }

    public void deleteFile(String name) {
        this.ensureOpen();
        this.impl.deleteFile(name);
    }

    @Override
    public void renameFile(String from, String to) {
        this.impl.renameFile(from, to);
    }

    public long fileLength(String name) {
        this.ensureOpen();
        return this.impl.fileLength(name);
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        return this.impl.createOutput(name);
    }

    public IndexInput openInput(String name, IOContext context) throws IOException {
        IndexInputContext indexInputContext = this.impl.openInput(name);
        if (indexInputContext.readLocks == null) {
            return new SingleChunkIndexInput(indexInputContext);
        }
        return new InfinispanIndexInput(indexInputContext);
    }

    public void close() {
    }

    public String toString() {
        return "InfinispanDirectory{indexName='" + this.indexName + "'}";
    }

    public String[] listAll() {
        return this.impl.list();
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    public void sync(Collection<String> names) throws IOException {
    }

    public void clearLock(String lockName) throws IOException {
        this.lockFactory.clearLock(lockName);
    }

    public LockFactory getLockFactory() {
        return this.lockFactory;
    }

    public Lock makeLock(String lockName) {
        return this.lockFactory.makeLock(lockName);
    }

    public void setLockFactory(LockFactory lockFactory) throws IOException {
        this.lockFactory = lockFactory;
    }

    @Override
    public int getChunkSize() {
        return this.impl.getChunkSize();
    }

    @Override
    public Cache getMetadataCache() {
        return this.impl.getMetadataCache();
    }

    @Override
    public Cache getDataCache() {
        return this.impl.getDataCache();
    }
}

