/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;

final class SlicedBufferIndexInput
extends IndexInput {
    private final byte[] buffer;
    private final int offset;
    private final int length;
    private final int hardLimit;
    private int bufferPosition;

    protected SlicedBufferIndexInput(String resourceDescription, byte[] buffer, long offset, long length) {
        super(resourceDescription);
        this.buffer = buffer;
        this.offset = SlicedBufferIndexInput.toInt(offset);
        this.length = SlicedBufferIndexInput.toInt(length);
        this.hardLimit = this.offset + this.length;
        this.bufferPosition = this.offset;
        if (this.hardLimit > buffer.length) {
            throw new IllegalArgumentException("offset or length too large for the size of this buffer");
        }
    }

    public void close() throws IOException {
    }

    public long getFilePointer() {
        return this.bufferPosition - this.offset;
    }

    public void seek(long pos) throws IOException {
        this.bufferPosition = Math.min(this.hardLimit, (int)pos + this.offset);
    }

    public long length() {
        return this.length;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new SlicedBufferIndexInput(sliceDescription, this.buffer, offset + (long)this.offset, length);
    }

    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.hardLimit) {
            throw new IOException("Read past EOF");
        }
        return this.buffer[this.bufferPosition++];
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.hardLimit - this.bufferPosition < len) {
            throw new IOException("Read past EOF");
        }
        System.arraycopy(this.buffer, this.bufferPosition, b, offset, len);
        this.bufferPosition += len;
    }

    private static int toInt(long n) {
        if (n < 0L || n > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("A SlicedBufferIndexInput can only be defined with offset and length which are positive and fit in an int");
        }
        return (int)n;
    }
}

