/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.infinispan.lucene.impl.InfinispanIndexInput;

final class SlicingInfinispanIndexInput
extends IndexInput {
    private final long offset;
    private final long length;
    private InfinispanIndexInput delegate;

    public SlicingInfinispanIndexInput(String sliceDescription, long offset, long length, InfinispanIndexInput delegate) {
        super(sliceDescription);
        this.offset = offset;
        this.length = length;
        this.delegate = delegate;
        delegate.seek(offset);
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    public long getFilePointer() {
        return this.delegate.getFilePointer() - this.offset;
    }

    public void seek(long pos) throws IOException {
        this.delegate.seek(pos + this.offset);
    }

    public long length() {
        return this.length;
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new SlicingInfinispanIndexInput(sliceDescription, offset + this.offset, length, this.delegate.copyAndReset());
    }

    public IndexInput clone() {
        SlicingInfinispanIndexInput clone = (SlicingInfinispanIndexInput)super.clone();
        clone.delegate = this.delegate.clone();
        return clone;
    }

    public byte readByte() throws IOException {
        return this.delegate.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.delegate.readBytes(b, offset, len);
    }
}

