/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.io.UnsignedNumeric;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.lucene.ExternalizerIds;

public final class FileMetadata {
    private long size = 0L;
    private final int bufferSize;

    public FileMetadata(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    private FileMetadata(long size, int bufferSize) {
        this.size = size;
        this.bufferSize = bufferSize;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public int getNumberOfChunks() {
        if (this.size % (long)this.bufferSize == 0L) {
            return (int)this.size / this.bufferSize;
        }
        return (int)(this.size / (long)this.bufferSize) + 1;
    }

    public boolean isMultiChunked() {
        return this.size > (long)this.bufferSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || FileMetadata.class != o.getClass()) {
            return false;
        }
        FileMetadata metadata = (FileMetadata)o;
        return this.size == metadata.size && this.bufferSize == metadata.bufferSize;
    }

    public int hashCode() {
        return (int)(this.size ^ this.size >>> 32);
    }

    public String toString() {
        return "FileMetadata{ size=" + this.size + '}';
    }

    public static final class Externalizer
    extends AbstractExternalizer<FileMetadata> {
        public void writeObject(ObjectOutput output, FileMetadata metadata) throws IOException {
            UnsignedNumeric.writeUnsignedLong((ObjectOutput)output, (long)metadata.size);
            UnsignedNumeric.writeUnsignedInt((ObjectOutput)output, (int)metadata.bufferSize);
        }

        public FileMetadata readObject(ObjectInput input) throws IOException {
            long size = UnsignedNumeric.readUnsignedLong((ObjectInput)input);
            int bufferSize = UnsignedNumeric.readUnsignedInt((ObjectInput)input);
            return new FileMetadata(size, bufferSize);
        }

        public Integer getId() {
            return ExternalizerIds.FILE_METADATA;
        }

        public Set<Class<? extends FileMetadata>> getTypeClasses() {
            return Collections.singleton(FileMetadata.class);
        }
    }
}

