/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.logging;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Locale;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.lucene.logging.Log;
import org.infinispan.persistence.spi.PersistenceException;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String errorExecutingParallelStoreTask = "ISPN000252: Error executing parallel store task";
    private static final String errorSuspendingTransaction = "ISPN015001: Error in suspending transaction";
    private static final String unableToStartTransaction = "ISPN015002: Unable to start transaction";
    private static final String unableToCommitTransaction = "ISPN015003: Unable to commit work done";
    private static final String keyMappperUnexpectedStringFormat = "ISPN015004: Unexpected format of key in String form: '%s'";
    private static final String cacheLoaderIgnoringKey = "ISPN015005: Lucene CacheLoader is ignoring key '%s'";
    private static final String rootDirectoryIsNotADirectory = "ISPN015006: The LuceneCacheLoader requires a directory; invalid path '%s'";
    private static final String unableToCreateDirectory = "ISPN015007: LuceneCacheLoader was unable to create the root directory at path '%s'";
    private static final String exceptionInCacheLoader = "ISPN015008: IOException happened in the CacheLoader";
    private static final String errorOnFSDirectoryClose = "ISPN015009: Unable to close FSDirectory";
    private static final String couldNotWalkDirectory = "ISPN015010: Error happened while looking for FSDirectories in '%s'";
    private static final String rescalingChunksize = "ISPN015011: The configured autoChunkSize is too small for segment file %s as it is %d bytes; auto-scaling chunk size to %d";
    private static final String luceneStorageHavingLifespanSet = "ISPN015014: Lucene Directory for index '%s' can not use Cache '%s': maximum lifespan enabled on the Cache configuration!";
    private static final String luceneStorageHavingIdleTimeSet = "ISPN015015: Lucene Directory for index '%s' can not use Cache '%s': expiration idle time enabled on the Cache configuration!";
    private static final String requiredParameterWasPassedNull = "ISPN015016: '%s' must not be null";
    private static final String luceneStorageAsBinaryEnabled = "ISPN015017: Lucene Directory for index '%s' can not use Cache '%s': store as binary enabled on the Cache configuration!";
    private static final String evictionNotAllowedInMetadataCache = "ISPN015018: Lucene Directory for index '%s' can not use Metadata Cache '%s': eviction enabled on the Cache configuration!";
    private static final String preloadNeededIfPersistenceIsEnabledForMetadataCache = "ISPN015019: Lucene Directory for index '%s' can not use Metadata Cache '%s': persistence enabled without preload on the Cache configuration!";
    private static final String luceneStorageNoStateTransferEnabled = "ISPN015020: Lucene Directory for index '%s' can not use Cache '%s': fetch in state is not enabled in Cache configuration!";
    private static final String affinityLocationIntoSegmentValueShallNotBeNegative = "ISPN015021: Lucene Directory for index '%s' can not set affinity location to segment id '%d': must be a positive integer!";
    private static final String cannotStoreIndexOnAsyncCaches = "ISPN015022: Lucene Directory for index '%s' cannot use cache '%s' with mode '%s'. Only SYNC caches are supported!";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    @Override
    public final void errorExecutingParallelStoreTask(Throwable cause) {
        this.log.logf(FQCN, Logger.Level.ERROR, cause, this.errorExecutingParallelStoreTask$str(), new Object[0]);
    }

    protected String errorExecutingParallelStoreTask$str() {
        return errorExecutingParallelStoreTask;
    }

    @Override
    public final void errorSuspendingTransaction(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.errorSuspendingTransaction$str(), new Object[0]);
    }

    protected String errorSuspendingTransaction$str() {
        return errorSuspendingTransaction;
    }

    @Override
    public final void unableToStartTransaction(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToStartTransaction$str(), new Object[0]);
    }

    protected String unableToStartTransaction$str() {
        return unableToStartTransaction;
    }

    @Override
    public final void unableToCommitTransaction(Exception e) {
        this.log.logf(FQCN, Logger.Level.ERROR, (Throwable)e, this.unableToCommitTransaction$str(), new Object[0]);
    }

    protected String unableToCommitTransaction$str() {
        return unableToCommitTransaction;
    }

    protected String keyMappperUnexpectedStringFormat$str() {
        return keyMappperUnexpectedStringFormat;
    }

    @Override
    public final IllegalArgumentException keyMappperUnexpectedStringFormat(String key) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.keyMappperUnexpectedStringFormat$str(), key));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void cacheLoaderIgnoringKey(Object key) {
        this.log.logf(FQCN, Logger.Level.DEBUG, null, this.cacheLoaderIgnoringKey$str(), key);
    }

    protected String cacheLoaderIgnoringKey$str() {
        return cacheLoaderIgnoringKey;
    }

    protected String rootDirectoryIsNotADirectory$str() {
        return rootDirectoryIsNotADirectory;
    }

    @Override
    public final CacheException rootDirectoryIsNotADirectory(String fileRoot) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.rootDirectoryIsNotADirectory$str(), fileRoot));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToCreateDirectory$str() {
        return unableToCreateDirectory;
    }

    @Override
    public final CacheException unableToCreateDirectory(String fileRoot) {
        CacheException result = new CacheException(String.format(this.getLoggingLocale(), this.unableToCreateDirectory$str(), fileRoot));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String exceptionInCacheLoader$str() {
        return exceptionInCacheLoader;
    }

    @Override
    public final PersistenceException exceptionInCacheLoader(Exception e) {
        PersistenceException result = new PersistenceException(String.format(this.getLoggingLocale(), this.exceptionInCacheLoader$str(), new Object[0]), (Throwable)e);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void errorOnFSDirectoryClose(IOException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.errorOnFSDirectoryClose$str(), new Object[0]);
    }

    protected String errorOnFSDirectoryClose$str() {
        return errorOnFSDirectoryClose;
    }

    @Override
    public final void couldNotWalkDirectory(String name, PersistenceException e) {
        this.log.logf(FQCN, Logger.Level.WARN, (Throwable)e, this.couldNotWalkDirectory$str(), (Object)name);
    }

    protected String couldNotWalkDirectory$str() {
        return couldNotWalkDirectory;
    }

    @Override
    public final void rescalingChunksize(String fileName, long fileLength, int chunkSize) {
        this.log.logf(FQCN, Logger.Level.WARN, null, this.rescalingChunksize$str(), (Object)fileName, (Object)fileLength, (Object)chunkSize);
    }

    protected String rescalingChunksize$str() {
        return rescalingChunksize;
    }

    protected String luceneStorageHavingLifespanSet$str() {
        return luceneStorageHavingLifespanSet;
    }

    @Override
    public final IllegalArgumentException luceneStorageHavingLifespanSet(String indexName, String cacheName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.luceneStorageHavingLifespanSet$str(), indexName, cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String luceneStorageHavingIdleTimeSet$str() {
        return luceneStorageHavingIdleTimeSet;
    }

    @Override
    public final IllegalArgumentException luceneStorageHavingIdleTimeSet(String indexName, String cacheName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.luceneStorageHavingIdleTimeSet$str(), indexName, cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String requiredParameterWasPassedNull$str() {
        return requiredParameterWasPassedNull;
    }

    @Override
    public final IllegalArgumentException requiredParameterWasPassedNull(String objectname) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.requiredParameterWasPassedNull$str(), objectname));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String luceneStorageAsBinaryEnabled$str() {
        return luceneStorageAsBinaryEnabled;
    }

    @Override
    public final IllegalArgumentException luceneStorageAsBinaryEnabled(String indexName, String cacheName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.luceneStorageAsBinaryEnabled$str(), indexName, cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String evictionNotAllowedInMetadataCache$str() {
        return evictionNotAllowedInMetadataCache;
    }

    @Override
    public final IllegalArgumentException evictionNotAllowedInMetadataCache(String indexName, String cacheName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.evictionNotAllowedInMetadataCache$str(), indexName, cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String preloadNeededIfPersistenceIsEnabledForMetadataCache$str() {
        return preloadNeededIfPersistenceIsEnabledForMetadataCache;
    }

    @Override
    public final IllegalArgumentException preloadNeededIfPersistenceIsEnabledForMetadataCache(String indexName, String cacheName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.preloadNeededIfPersistenceIsEnabledForMetadataCache$str(), indexName, cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String luceneStorageNoStateTransferEnabled$str() {
        return luceneStorageNoStateTransferEnabled;
    }

    @Override
    public final IllegalArgumentException luceneStorageNoStateTransferEnabled(String indexName, String cacheName) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.luceneStorageNoStateTransferEnabled$str(), indexName, cacheName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String affinityLocationIntoSegmentValueShallNotBeNegative$str() {
        return affinityLocationIntoSegmentValueShallNotBeNegative;
    }

    @Override
    public final IllegalArgumentException affinityLocationIntoSegmentValueShallNotBeNegative(String indexName, int segmentId) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.affinityLocationIntoSegmentValueShallNotBeNegative$str(), indexName, segmentId));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotStoreIndexOnAsyncCaches$str() {
        return cannotStoreIndexOnAsyncCaches;
    }

    @Override
    public final IllegalArgumentException cannotStoreIndexOnAsyncCaches(String indexName, String cacheName, CacheMode used) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.cannotStoreIndexOnAsyncCaches$str(), indexName, cacheName, used));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

