/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.readlocks;

import java.util.HashMap;
import org.infinispan.Cache;
import org.infinispan.lucene.readlocks.DistributedSegmentReadLocker;
import org.infinispan.lucene.readlocks.SegmentReadLocker;

public class LocalLockMergingSegmentReadLocker
implements SegmentReadLocker {
    private final HashMap<String, LocalReadLock> localLocks = new HashMap();
    private final DistributedSegmentReadLocker delegate;

    public LocalLockMergingSegmentReadLocker(Cache<?, ?> cache, String indexName, int affinitySegmentId) {
        this.delegate = new DistributedSegmentReadLocker(cache, cache, cache, indexName, affinitySegmentId);
    }

    public LocalLockMergingSegmentReadLocker(Cache<?, ?> locksCache, Cache<?, ?> chunksCache, Cache<?, ?> metadataCache, String indexName, int affinitySegmentId) {
        this.delegate = new DistributedSegmentReadLocker(locksCache, chunksCache, metadataCache, indexName, affinitySegmentId);
    }

    public LocalLockMergingSegmentReadLocker(Cache<?, ?> locksCache, Cache<?, ?> chunksCache, Cache<?, ?> metadataCache, String indexName, boolean forceSynchronousDeletes, int affinitySegmentId) {
        this.delegate = new DistributedSegmentReadLocker(locksCache, chunksCache, metadataCache, indexName, affinitySegmentId, forceSynchronousDeletes);
    }

    @Override
    public synchronized boolean acquireReadLock(String name) {
        LocalReadLock localReadLock = this.getLocalLockByName(name);
        boolean acquired = localReadLock.acquire();
        if (acquired) {
            return true;
        }
        this.localLocks.remove(name);
        return false;
    }

    private LocalReadLock getLocalLockByName(String name) {
        LocalReadLock localReadLock = this.localLocks.get(name);
        if (localReadLock == null) {
            LocalReadLock newReadLock = new LocalReadLock(name);
            this.localLocks.put(name, newReadLock);
            return newReadLock;
        }
        return localReadLock;
    }

    @Override
    public synchronized void deleteOrReleaseReadLock(String name) {
        this.getLocalLockByName(name).release();
    }

    private class LocalReadLock {
        private final String name;
        private int value = 0;

        LocalReadLock(String name) {
            this.name = name;
        }

        boolean acquire() {
            if (this.value == 0) {
                boolean haveIt = LocalLockMergingSegmentReadLocker.this.delegate.acquireReadLock(this.name);
                if (haveIt) {
                    this.value = 1;
                    return true;
                }
                this.value = -1;
                return false;
            }
            if (this.value == -1) {
                return false;
            }
            ++this.value;
            return true;
        }

        void release() {
            --this.value;
            if (this.value <= 0) {
                LocalLockMergingSegmentReadLocker.this.localLocks.remove(this.name);
                LocalLockMergingSegmentReadLocker.this.delegate.deleteOrReleaseReadLock(this.name);
            }
        }
    }
}

