/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.lucene.impl;

import org.apache.lucene.store.IndexOutput;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.lucene.ChunkCacheKey;
import org.infinispan.lucene.FileCacheKey;
import org.infinispan.lucene.FileMetadata;
import org.infinispan.lucene.impl.CheckSummingIndexOutput;
import org.infinispan.lucene.impl.DirectoryImplementor;
import org.infinispan.lucene.readlocks.SegmentReadLocker;

public class DirectoryImplementorV4
extends DirectoryImplementor {
    private final FileCacheKey segmentsGenFileKey;

    public DirectoryImplementorV4(Cache<?, ?> metadataCache, Cache<?, ?> chunksCache, String indexName, int chunkSize, SegmentReadLocker readLocker) {
        super(metadataCache, chunksCache, indexName, chunkSize, readLocker);
        this.segmentsGenFileKey = new FileCacheKey(indexName, "segments.gen");
    }

    IndexOutput createOutput(String name) {
        if ("segments.gen".equals(name)) {
            return new CheckSummingIndexOutput((AdvancedCache<FileCacheKey, FileMetadata>)this.metadataCache, (AdvancedCache<ChunkCacheKey, Object>)this.chunksCache, this.segmentsGenFileKey, this.chunkSize, this.fileOps);
        }
        FileCacheKey key = new FileCacheKey(this.indexName, name);
        return new CheckSummingIndexOutput((AdvancedCache<FileCacheKey, FileMetadata>)this.metadataCache, (AdvancedCache<ChunkCacheKey, Object>)this.chunksCache, key, this.chunkSize, this.fileOps);
    }
}

