/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ImplicitConverters;
import io.smallrye.config.SecuritySupport;
import io.smallrye.config.StringUtil;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.IntFunction;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.spi.Converter;

public final class Converters {
    static final Converter<String> STRING_CONVERTER = BuiltInConverter.of(0, (Converter<Object> & Serializable)value -> value);
    static final Converter<Boolean> BOOLEAN_CONVERTER = BuiltInConverter.of(1, (Converter<Object> & Serializable)value -> {
        if (value != null) {
            return "TRUE".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "YES".equalsIgnoreCase(value) || "Y".equalsIgnoreCase(value) || "ON".equalsIgnoreCase(value) || "JA".equalsIgnoreCase(value) || "J".equalsIgnoreCase(value) || "SI".equalsIgnoreCase(value) || "SIM".equalsIgnoreCase(value) || "OUI".equalsIgnoreCase(value);
        }
        return null;
    });
    static final Converter<Double> DOUBLE_CONVERTER = BuiltInConverter.of(2, (Converter<Object> & Serializable)value -> value != null ? Double.valueOf(value) : null);
    static final Converter<Float> FLOAT_CONVERTER = BuiltInConverter.of(3, (Converter<Object> & Serializable)value -> value != null ? Float.valueOf(value) : null);
    static final Converter<Long> LONG_CONVERTER = BuiltInConverter.of(4, (Converter<Object> & Serializable)value -> value != null ? Long.valueOf(value) : null);
    static final Converter<Integer> INTEGER_CONVERTER = BuiltInConverter.of(5, (Converter<Object> & Serializable)value -> value != null ? Integer.valueOf(value) : null);
    static final Converter<Class<?>> CLASS_CONVERTER = BuiltInConverter.of(6, (Converter<Object> & Serializable)value -> {
        try {
            return value != null ? Class.forName(value, true, SecuritySupport.getContextClassLoader()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    });
    static final Converter<OptionalInt> OPTIONAL_INT_CONVERTER = BuiltInConverter.of(7, (Converter<OptionalInt> & Serializable)value -> value != null && !value.isEmpty() ? OptionalInt.of(Integer.parseInt(value)) : OptionalInt.empty());
    static final Converter<OptionalLong> OPTIONAL_LONG_CONVERTER = BuiltInConverter.of(8, (Converter<OptionalLong> & Serializable)value -> value != null && !value.isEmpty() ? OptionalLong.of(Long.parseLong(value)) : OptionalLong.empty());
    static final Converter<OptionalDouble> OPTIONAL_DOUBLE_CONVERTER = BuiltInConverter.of(9, (Converter<OptionalDouble> & Serializable)value -> value != null && !value.isEmpty() ? OptionalDouble.of(Double.parseDouble(value)) : OptionalDouble.empty());
    static final Converter<InetAddress> INET_ADDRESS_CONVERTER = BuiltInConverter.of(10, (Converter<InetAddress> & Serializable)value -> {
        try {
            return value != null && !value.isEmpty() ? InetAddress.getByName(value) : null;
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException(e);
        }
    });
    static final Converter<Character> CHARACTER_CONVERTER = BuiltInConverter.of(11, (Converter<Object> & Serializable)value -> {
        if (value != null) {
            if (value.length() == 1) {
                return Character.valueOf(value.charAt(0));
            }
            throw new IllegalArgumentException(value + " can not be converted to a Character");
        }
        return null;
    });
    static final Map<Type, Converter<?>> ALL_CONVERTERS = new HashMap();

    private Converters() {
    }

    public static Type getConverterType(Class<?> clazz) {
        if (clazz.equals(Object.class)) {
            return null;
        }
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType pt;
            if (!(type instanceof ParameterizedType) || !(pt = (ParameterizedType)type).getRawType().equals(Converter.class)) continue;
            Type[] typeArguments = pt.getActualTypeArguments();
            if (typeArguments.length != 1) {
                throw new IllegalStateException("Converter " + clazz + " must be parameterized with a single type");
            }
            return typeArguments[0];
        }
        return Converters.getConverterType(clazz.getSuperclass());
    }

    public static <T> Converter<T> getImplicitConverter(Class<T> type) {
        return ImplicitConverters.getConverter(type);
    }

    public static <T, C extends Collection<T>> Converter<C> newCollectionConverter(Converter<T> itemConverter, IntFunction<C> collectionFactory) {
        return new CollectionConverter<T, C>(itemConverter, collectionFactory);
    }

    public static <A, T> Converter<A> newArrayConverter(Converter<T> itemConverter, Class<A> arrayType) {
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException(arrayType.toString() + " is not an array type");
        }
        return new ArrayConverter<A, T>(itemConverter, arrayType);
    }

    public static <T extends Comparable<T>> Converter<T> minimumValueConverter(Converter<T> delegate, T minimumValue, boolean inclusive) {
        return new RangeCheckConverter<Object>((Converter<Object>)delegate, minimumValue, inclusive, null, false);
    }

    public static <T extends Comparable<T>> Converter<T> maximumValueConverter(Converter<T> delegate, T maximumValue, boolean inclusive) {
        return new RangeCheckConverter<Object>((Converter<Object>)delegate, null, false, maximumValue, inclusive);
    }

    public static <T extends Comparable<T>> Converter<T> rangeValueConverter(Converter<T> delegate, T minimumValue, boolean minInclusive, T maximumValue, boolean maxInclusive) {
        return new RangeCheckConverter<T>(delegate, minimumValue, minInclusive, maximumValue, maxInclusive);
    }

    public static <T> Converter<T> patternValidatingConverter(Converter<T> delegate, Pattern pattern) {
        return new PatternCheckConverter<T>(delegate, pattern);
    }

    public static <T> Converter<T> patternValidatingConverter(Converter<T> delegate, String pattern) {
        return Converters.patternValidatingConverter(delegate, Pattern.compile(pattern));
    }

    static {
        ALL_CONVERTERS.put((Type)((Object)String.class), STRING_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Boolean.class), BOOLEAN_CONVERTER);
        ALL_CONVERTERS.put(Boolean.TYPE, BOOLEAN_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Double.class), DOUBLE_CONVERTER);
        ALL_CONVERTERS.put(Double.TYPE, DOUBLE_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Float.class), FLOAT_CONVERTER);
        ALL_CONVERTERS.put(Float.TYPE, FLOAT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Long.class), LONG_CONVERTER);
        ALL_CONVERTERS.put(Long.TYPE, LONG_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Integer.class), INTEGER_CONVERTER);
        ALL_CONVERTERS.put(Integer.TYPE, INTEGER_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Class.class), CLASS_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)InetAddress.class), INET_ADDRESS_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalInt.class), OPTIONAL_INT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalLong.class), OPTIONAL_LONG_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalDouble.class), OPTIONAL_DOUBLE_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Character.class), CHARACTER_CONVERTER);
        ALL_CONVERTERS.put(Character.TYPE, CHARACTER_CONVERTER);
    }

    static final class Ser
    implements Serializable {
        private static final long serialVersionUID = 5646753664957303950L;
        private final short id;

        Ser(int id) {
            this.id = (short)id;
        }

        Object readResolve() throws ObjectStreamException {
            switch (this.id) {
                case 0: {
                    return STRING_CONVERTER;
                }
                case 1: {
                    return BOOLEAN_CONVERTER;
                }
                case 2: {
                    return DOUBLE_CONVERTER;
                }
                case 3: {
                    return FLOAT_CONVERTER;
                }
                case 4: {
                    return LONG_CONVERTER;
                }
                case 5: {
                    return INTEGER_CONVERTER;
                }
                case 6: {
                    return CLASS_CONVERTER;
                }
                case 7: {
                    return OPTIONAL_INT_CONVERTER;
                }
                case 8: {
                    return OPTIONAL_LONG_CONVERTER;
                }
                case 9: {
                    return OPTIONAL_DOUBLE_CONVERTER;
                }
                case 10: {
                    return INET_ADDRESS_CONVERTER;
                }
                case 11: {
                    return CHARACTER_CONVERTER;
                }
            }
            throw new InvalidObjectException("Unknown converter ID");
        }
    }

    static final class BuiltInConverter<T>
    implements Converter<T>,
    Serializable {
        private final int id;
        private final Converter<T> function;

        static <T> BuiltInConverter<T> of(int id, Converter<T> function) {
            return new BuiltInConverter<T>(id, function);
        }

        private BuiltInConverter(int id, Converter<T> function) {
            this.id = id;
            this.function = function;
        }

        @Override
        public T convert(String value) {
            return this.function.convert(value);
        }

        Object writeReplace() {
            return new Ser(this.id);
        }
    }

    static final class ArrayConverter<A, T>
    implements Converter<A>,
    Serializable {
        private static final long serialVersionUID = 2630282286159527380L;
        private final Converter<T> itemConverter;
        private final Class<A> arrayType;

        ArrayConverter(Converter<T> itemConverter, Class<A> arrayType) {
            this.itemConverter = itemConverter;
            this.arrayType = arrayType;
        }

        @Override
        public A convert(String str) {
            if (str.isEmpty()) {
                return null;
            }
            String[] itemStrings = StringUtil.split(str);
            A array = this.arrayType.cast(Array.newInstance(this.arrayType.getComponentType(), itemStrings.length));
            int size = 0;
            for (String itemString : itemStrings) {
                T item;
                if (itemString.isEmpty() || (item = this.itemConverter.convert(itemString)) == null) continue;
                Array.set(array, size++, item);
            }
            return size == 0 ? null : (size < itemStrings.length ? (A)ArrayConverter.copyArray(array, this.arrayType, size) : (A)array);
        }

        private static <A> A copyArray(A array, Class<A> arrayType, int newSize) {
            if (array instanceof Object[]) {
                return arrayType.cast(Arrays.copyOf((Object[])array, newSize));
            }
            if (array instanceof boolean[]) {
                return arrayType.cast(Arrays.copyOf((boolean[])array, newSize));
            }
            if (array instanceof char[]) {
                return arrayType.cast(Arrays.copyOf((char[])array, newSize));
            }
            if (array instanceof byte[]) {
                return arrayType.cast(Arrays.copyOf((byte[])array, newSize));
            }
            if (array instanceof short[]) {
                return arrayType.cast(Arrays.copyOf((short[])array, newSize));
            }
            if (array instanceof int[]) {
                return arrayType.cast(Arrays.copyOf((int[])array, newSize));
            }
            if (array instanceof long[]) {
                return arrayType.cast(Arrays.copyOf((long[])array, newSize));
            }
            if (array instanceof float[]) {
                return arrayType.cast(Arrays.copyOf((float[])array, newSize));
            }
            if (array instanceof double[]) {
                return arrayType.cast(Arrays.copyOf((double[])array, newSize));
            }
            throw new IllegalStateException();
        }
    }

    static final class CollectionConverter<T, C extends Collection<T>>
    implements Converter<C>,
    Serializable {
        private static final long serialVersionUID = -8452214026800305628L;
        private final Converter<T> itemConverter;
        private final IntFunction<C> collectionFactory;

        CollectionConverter(Converter<T> itemConverter, IntFunction<C> collectionFactory) {
            this.itemConverter = itemConverter;
            this.collectionFactory = collectionFactory;
        }

        @Override
        public C convert(String str) {
            if (str.isEmpty()) {
                return null;
            }
            String[] itemStrings = StringUtil.split(str);
            Collection collection = (Collection)this.collectionFactory.apply(itemStrings.length);
            for (String itemString : itemStrings) {
                T item;
                if (itemString.isEmpty() || (item = this.itemConverter.convert(itemString)) == null) continue;
                collection.add(item);
            }
            return (C)(collection.isEmpty() ? null : collection);
        }
    }

    static final class RangeCheckConverter<T extends Comparable<T>>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 2764654140347010865L;
        private final Converter<T> delegate;
        private final T min;
        private final boolean minInclusive;
        private final T max;
        private final boolean maxInclusive;

        RangeCheckConverter(Converter<T> delegate, T min, boolean minInclusive, T max, boolean maxInclusive) {
            this.delegate = delegate;
            this.min = min;
            this.minInclusive = minInclusive;
            this.max = max;
            this.maxInclusive = maxInclusive;
        }

        @Override
        public T convert(String value) {
            int cmp;
            Comparable result = (Comparable)this.delegate.convert(value);
            if (result == null) {
                return null;
            }
            if (this.min != null) {
                cmp = result.compareTo(this.min);
                if (this.minInclusive) {
                    if (cmp < 0) {
                        throw new IllegalArgumentException("Value must not be less than " + this.min + " (value was \"" + value + "\")");
                    }
                } else if (cmp <= 0) {
                    throw new IllegalArgumentException("Value must not be less than or equal to" + this.min + " (value was \"" + value + "\")");
                }
            }
            if (this.max != null) {
                cmp = result.compareTo(this.max);
                if (this.maxInclusive) {
                    if (cmp > 0) {
                        throw new IllegalArgumentException("Value must not be greater than " + this.max + " (value was \"" + value + "\")");
                    }
                } else if (cmp >= 0) {
                    throw new IllegalArgumentException("Value must not be greater than or equal to" + this.max + " (value was \"" + value + "\")");
                }
            }
            return (T)result;
        }
    }

    static final class PatternCheckConverter<T>
    implements Converter<T>,
    Serializable {
        private static final long serialVersionUID = 358813973126582008L;
        private final Converter<T> delegate;
        private final Pattern pattern;

        PatternCheckConverter(Converter<T> delegate, Pattern pattern) {
            this.delegate = delegate;
            this.pattern = pattern;
        }

        @Override
        public T convert(String value) {
            if (value == null) {
                return null;
            }
            if (this.pattern.matcher(value).matches()) {
                return this.delegate.convert(value);
            }
            throw new IllegalArgumentException("Value does not match pattern " + this.pattern + " (value was \"" + value + "\")");
        }
    }
}

