/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.inject.spi.Annotated;

class AnnotatedDecorator
implements Annotated {
    private final Annotated decorated;
    private final Set<Annotation> annotations;

    AnnotatedDecorator(Annotated decorated, Set<Annotation> annotations) {
        this.decorated = decorated;
        this.annotations = annotations;
    }

    @Override
    public Type getBaseType() {
        return this.decorated.getBaseType();
    }

    @Override
    public Set<Type> getTypeClosure() {
        return this.decorated.getTypeClosure();
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        T annotation = this.getDecoratingAnnotation(annotationType);
        if (annotation != null) {
            return annotation;
        }
        return this.decorated.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> Set<T> getAnnotations(Class<T> annotationType) {
        return this.decorated.getAnnotations(annotationType);
    }

    @Override
    public Set<Annotation> getAnnotations() {
        HashSet<Annotation> annotations = new HashSet<Annotation>(this.annotations);
        annotations.addAll(this.decorated.getAnnotations());
        return Collections.unmodifiableSet(annotations);
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
        return this.getDecoratingAnnotation(annotationType) != null || this.decorated.isAnnotationPresent(annotationType);
    }

    private <T extends Annotation> T getDecoratingAnnotation(Class<T> annotationType) {
        for (Annotation annotation : this.annotations) {
            if (!annotationType.isAssignableFrom(annotation.annotationType())) continue;
            return (T)annotation;
        }
        return null;
    }
}

