/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.setup;

import io.smallrye.metrics.ExtendedMetadata;
import io.smallrye.metrics.ExtendedMetadataAndTags;
import io.smallrye.metrics.JmxWorker;
import io.smallrye.metrics.MetricRegistries;
import io.smallrye.metrics.mbean.MCounterImpl;
import io.smallrye.metrics.mbean.MGaugeImpl;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Tag;

public class JmxRegistrar {
    public void init() throws IOException {
        this.register("base-metrics.properties", MetricRegistries.get(MetricRegistry.Type.BASE));
        this.register("vendor-metrics.properties", MetricRegistries.get(MetricRegistry.Type.VENDOR));
    }

    private void register(String propertiesFile, MetricRegistry registry) throws IOException {
        List<ExtendedMetadataAndTags> configs = this.findMetadata(propertiesFile);
        for (ExtendedMetadataAndTags config : configs) {
            this.register(registry, config.getMetadata(), config.getTags());
        }
    }

    void register(MetricRegistry registry, ExtendedMetadata config, List<Tag> tags) {
        Metric metric = null;
        switch (config.getTypeRaw()) {
            case COUNTER: {
                metric = new MCounterImpl(JmxWorker.instance(), config.getMbean());
                break;
            }
            case GAUGE: {
                metric = new MGaugeImpl(JmxWorker.instance(), config.getMbean());
            }
        }
        if (metric != null) {
            registry.register(config, metric, tags.toArray(new Tag[0]));
        }
    }

    private List<ExtendedMetadataAndTags> findMetadata(String propertiesFile) throws IOException {
        try (InputStream propertiesResource = this.getResource("/io/smallrye/metrics/" + propertiesFile);){
            if (propertiesResource == null) {
                List<ExtendedMetadataAndTags> list = Collections.emptyList();
                return list;
            }
            List<ExtendedMetadataAndTags> resultList = this.loadMetadataFromProperties(propertiesResource);
            JmxWorker.instance().expandMultiValueEntries(resultList);
            List<ExtendedMetadataAndTags> list = resultList;
            return list;
        }
    }

    List<ExtendedMetadataAndTags> loadMetadataFromProperties(InputStream propertiesResource) throws IOException {
        Properties baseMetricsProps = new Properties();
        baseMetricsProps.load(propertiesResource);
        Map<String, List<MetricProperty>> parsedMetrics = baseMetricsProps.entrySet().stream().map(MetricProperty::new).collect(Collectors.groupingBy(MetricProperty::getMetricName));
        return parsedMetrics.entrySet().stream().map(this::metadataOf).sorted(Comparator.comparing(e -> e.getMetadata().getName())).collect(Collectors.toList());
    }

    private InputStream getResource(String location) {
        InputStream is = this.getClass().getResourceAsStream(location);
        if (is == null) {
            is = Thread.currentThread().getContextClassLoader().getResourceAsStream(location);
        }
        return is;
    }

    private ExtendedMetadataAndTags metadataOf(Map.Entry<String, List<MetricProperty>> metadataEntry) {
        String name = metadataEntry.getKey();
        HashMap entryProperties = new HashMap();
        metadataEntry.getValue().forEach(prop -> entryProperties.put(prop.propertyKey, prop.propertyValue));
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (entryProperties.containsKey("tags")) {
            String[] labelDefs;
            for (String labelDef : labelDefs = ((String)entryProperties.get("tags")).split(";")) {
                String[] label = labelDef.split("=", 2);
                Tag tag = new Tag(label[0], label[1]);
                tags.add(tag);
            }
        }
        ExtendedMetadata meta = new ExtendedMetadata(name, (String)entryProperties.get("displayName"), (String)entryProperties.get("description"), this.metricTypeOf((String)entryProperties.get("type")), (String)entryProperties.get("unit"), (String)entryProperties.get("mbean"), "true".equalsIgnoreCase((String)entryProperties.get("multi")));
        return new ExtendedMetadataAndTags(meta, tags);
    }

    MetricType metricTypeOf(String type) {
        return MetricType.valueOf(type.toUpperCase());
    }

    private static class MetricProperty {
        String metricName;
        String propertyKey;
        String propertyValue;

        MetricProperty(Map.Entry<Object, Object> keyValue) {
            String key = (String)keyValue.getKey();
            int propertyIdEnd = key.lastIndexOf(46);
            this.metricName = key.substring(0, propertyIdEnd);
            this.propertyKey = key.substring(propertyIdEnd + 1);
            this.propertyValue = (String)keyValue.getValue();
        }

        String getMetricName() {
            return this.metricName;
        }
    }
}

