/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.marshaller.protostuff;

import io.protostuff.LinkedBuffer;
import io.protostuff.ProtostuffIOUtil;
import io.protostuff.Schema;
import io.protostuff.runtime.RuntimeSchema;
import java.io.IOException;
import java.util.ServiceLoader;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.io.ByteBuffer;
import org.infinispan.commons.io.ByteBufferImpl;
import org.infinispan.commons.marshall.AbstractMarshaller;
import org.infinispan.marshaller.protostuff.SchemaRegistryService;
import org.infinispan.marshaller.protostuff.Wrapper;

public class ProtostuffMarshaller
extends AbstractMarshaller {
    private static final Schema<Wrapper> WRAPPER_SCHEMA;

    public Object objectFromByteBuffer(byte[] bytes, int offset, int length) throws IOException, ClassNotFoundException {
        Wrapper wrapper = WRAPPER_SCHEMA.newMessage();
        ProtostuffIOUtil.mergeFrom(bytes, offset, length, wrapper, WRAPPER_SCHEMA);
        return wrapper.object;
    }

    protected ByteBuffer objectToBuffer(Object obj, int estimatedSize) throws IOException, InterruptedException {
        LinkedBuffer buffer = estimatedSize < 256 ? LinkedBuffer.allocate(256) : LinkedBuffer.allocate(estimatedSize);
        byte[] bytes = ProtostuffIOUtil.toByteArray(new Wrapper(obj), WRAPPER_SCHEMA, buffer);
        return new ByteBufferImpl(bytes, 0, bytes.length);
    }

    public boolean isMarshallable(Object obj) throws Exception {
        try {
            this.objectToBuffer(obj);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public MediaType mediaType() {
        return MediaType.APPLICATION_PROTOSTUFF;
    }

    static {
        ClassLoader loader = ProtostuffMarshaller.class.getClassLoader();
        ServiceLoader.load(SchemaRegistryService.class, loader).forEach(SchemaRegistryService::register);
        WRAPPER_SCHEMA = RuntimeSchema.getSchema(Wrapper.class);
    }
}

