/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import java.io.Serializable;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class EnvConfigSource
implements ConfigSource,
Serializable {
    EnvConfigSource() {
    }

    @Override
    public Map<String, String> getProperties() {
        Map env = AccessController.doPrivileged(System::getenv);
        return Collections.unmodifiableMap(env);
    }

    @Override
    public int getOrdinal() {
        return 300;
    }

    @Override
    public String getValue(String name) {
        if (name == null) {
            return null;
        }
        String value = AccessController.doPrivileged(() -> System.getenv(name));
        if (value != null) {
            return value;
        }
        String sanitizedName = name.replaceAll("[^a-zA-Z0-9_]", "_");
        value = AccessController.doPrivileged(() -> System.getenv(sanitizedName));
        if (value != null) {
            return value;
        }
        return AccessController.doPrivileged(() -> System.getenv(sanitizedName.toUpperCase()));
    }

    @Override
    public String getName() {
        return "EnvConfigSource";
    }
}

