/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.app;

import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.microprofile.metrics.ConcurrentGauge;

public class ConcurrentGaugeImpl
implements ConcurrentGauge {
    private final AtomicLong count = new AtomicLong(0L);
    private final AtomicLong max_previousMinute = new AtomicLong(0L);
    private final AtomicLong min_previousMinute = new AtomicLong(0L);
    private final AtomicLong max_thisMinute = new AtomicLong(0L);
    private final AtomicLong min_thisMinute = new AtomicLong(0L);
    private final AtomicLong thisMinute = new AtomicLong(this.getCurrentMinuteFromSystem());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void inc() {
        this.maybeStartNewMinute();
        ConcurrentGaugeImpl concurrentGaugeImpl = this;
        synchronized (concurrentGaugeImpl) {
            long newCount = this.count.incrementAndGet();
            if (newCount > this.max_thisMinute.get()) {
                this.max_thisMinute.set(newCount);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dec() {
        this.maybeStartNewMinute();
        ConcurrentGaugeImpl concurrentGaugeImpl = this;
        synchronized (concurrentGaugeImpl) {
            long newCount = this.count.decrementAndGet();
            if (newCount < this.min_thisMinute.get()) {
                this.min_thisMinute.set(newCount);
            }
        }
    }

    @Override
    public long getCount() {
        this.maybeStartNewMinute();
        return this.count.get();
    }

    @Override
    public long getMax() {
        this.maybeStartNewMinute();
        return this.max_previousMinute.get();
    }

    @Override
    public long getMin() {
        this.maybeStartNewMinute();
        return this.min_previousMinute.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeStartNewMinute() {
        long newMinute = this.getCurrentMinuteFromSystem();
        if (newMinute > this.thisMinute.get()) {
            ConcurrentGaugeImpl concurrentGaugeImpl = this;
            synchronized (concurrentGaugeImpl) {
                if (newMinute > this.thisMinute.get()) {
                    this.thisMinute.set(newMinute);
                    this.max_previousMinute.set(this.max_thisMinute.get());
                    this.min_previousMinute.set(this.min_thisMinute.get());
                    this.max_thisMinute.set(this.count.get());
                    this.min_thisMinute.set(this.count.get());
                }
            }
        }
    }

    private long getCurrentMinuteFromSystem() {
        return System.currentTimeMillis() / 60000L;
    }
}

