/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.app;

import io.smallrye.metrics.app.Reservoir;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Snapshot;

public class HistogramImpl
implements Histogram {
    private final Reservoir reservoir;
    private final LongAdder count;

    public HistogramImpl(Reservoir reservoir) {
        this.reservoir = reservoir;
        this.count = new LongAdder();
    }

    @Override
    public void update(int value) {
        this.update((long)value);
    }

    @Override
    public void update(long value) {
        this.count.increment();
        this.reservoir.update(value);
    }

    @Override
    public long getCount() {
        return this.count.sum();
    }

    @Override
    public Snapshot getSnapshot() {
        return this.reservoir.getSnapshot();
    }
}

