/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.interceptors;

import io.smallrye.metrics.TagsUtils;
import io.smallrye.metrics.elementdesc.AnnotationInfo;
import io.smallrye.metrics.elementdesc.BeanInfo;
import io.smallrye.metrics.elementdesc.MemberInfo;
import io.smallrye.metrics.elementdesc.MemberType;
import io.smallrye.metrics.interceptors.MetricName;
import io.smallrye.metrics.interceptors.SeMetricName;
import java.lang.annotation.Annotation;
import java.util.Collections;
import javax.enterprise.inject.Vetoed;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;
import org.eclipse.microprofile.metrics.annotation.ConcurrentGauge;
import org.eclipse.microprofile.metrics.annotation.Counted;
import org.eclipse.microprofile.metrics.annotation.Gauge;
import org.eclipse.microprofile.metrics.annotation.Metered;
import org.eclipse.microprofile.metrics.annotation.Timed;

@Vetoed
public class MetricResolver {
    private MetricName metricName = new SeMetricName(Collections.emptySet());

    public Of<Counted> counted(BeanInfo topClass, MemberInfo element) {
        return this.resolverOf(topClass, element, Counted.class);
    }

    public Of<ConcurrentGauge> concurrentGauge(BeanInfo topClass, MemberInfo element) {
        return this.resolverOf(topClass, element, ConcurrentGauge.class);
    }

    public Of<Gauge> gauge(BeanInfo topClass, MemberInfo method) {
        return this.resolverOf(topClass, method, Gauge.class);
    }

    public Of<Metered> metered(BeanInfo topClass, MemberInfo element) {
        return this.resolverOf(topClass, element, Metered.class);
    }

    public Of<Timed> timed(BeanInfo bean, MemberInfo element) {
        return this.resolverOf(bean, element, Timed.class);
    }

    private <T extends Annotation> Of<T> resolverOf(BeanInfo bean, MemberInfo element, Class<T> metric) {
        if (element.isAnnotationPresent(metric)) {
            return this.elementResolverOf(element, metric);
        }
        return this.beanResolverOf(element, metric, bean);
    }

    private <T extends Annotation> Of<T> elementResolverOf(MemberInfo element, Class<T> metric) {
        AnnotationInfo annotation = element.getAnnotation(metric);
        String name = this.metricName(element, metric, annotation.name(), annotation.absolute());
        Tag[] tags = this.metricTags(annotation);
        return new DoesHaveMetric(annotation, name, tags);
    }

    private <T extends Annotation> Of<T> beanResolverOf(MemberInfo element, Class<T> metric, BeanInfo bean) {
        if (bean.isAnnotationPresent(metric)) {
            AnnotationInfo annotation = bean.getAnnotation(metric);
            String name = this.metricName(bean, element, metric, annotation.name(), annotation.absolute());
            Tag[] tags = this.metricTags(annotation);
            return new DoesHaveMetric(annotation, name, tags);
        }
        if (bean.getSuperclass() != null) {
            return this.beanResolverOf(element, metric, bean.getSuperclass());
        }
        return new DoesNotHaveMetric();
    }

    private String metricName(MemberInfo element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? this.defaultName(element, type) : this.metricName.of(name);
        return absolute ? metric : MetricRegistry.name(element.getDeclaringClassName(), metric);
    }

    private String metricName(BeanInfo bean, MemberInfo element, Class<? extends Annotation> type, String name, boolean absolute) {
        String metric = name.isEmpty() ? bean.getSimpleName() : this.metricName.of(name);
        return absolute ? MetricRegistry.name(metric, this.defaultName(element, type)) : MetricRegistry.name(bean.getPackageName(), metric, this.defaultName(element, type));
    }

    private String defaultName(MemberInfo element, Class<? extends Annotation> type) {
        return this.memberName(element);
    }

    private String memberName(MemberInfo member) {
        if (member.getMemberType() == MemberType.CONSTRUCTOR) {
            return member.getDeclaringClassSimpleName();
        }
        return member.getName();
    }

    private Tag[] metricTags(AnnotationInfo annotation) {
        return TagsUtils.parseTagsAsArray(annotation.tags());
    }

    @Vetoed
    private static final class DoesNotHaveMetric<T extends Annotation>
    implements Of<T> {
        private DoesNotHaveMetric() {
        }

        @Override
        public boolean isPresent() {
            return false;
        }

        @Override
        public String metricName() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Tag[] tags() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AnnotationInfo metricAnnotation() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DoesHaveMetric<T extends Annotation>
    implements Of<T> {
        private final AnnotationInfo annotation;
        private final String name;
        private final Tag[] tags;

        private DoesHaveMetric(AnnotationInfo annotation, String name, Tag[] tags) {
            this.annotation = annotation;
            this.name = name;
            this.tags = tags;
        }

        @Override
        public boolean isPresent() {
            return true;
        }

        @Override
        public String metricName() {
            return this.name;
        }

        @Override
        public Tag[] tags() {
            return this.tags;
        }

        @Override
        public AnnotationInfo metricAnnotation() {
            return this.annotation;
        }
    }

    public static interface Of<T extends Annotation> {
        public boolean isPresent();

        public String metricName();

        public Tag[] tags();

        public AnnotationInfo metricAnnotation();
    }
}

